/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi.datastore.tasks;

import com.sonatype.nexus.repository.pypi.AssetKind;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.logging.task.TaskLogType;
import org.sonatype.nexus.logging.task.TaskLogging;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.RepositoryTaskSupport;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.types.ProxyType;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.CancelableHelper;

@Named
@TaskLogging(value=TaskLogType.NEXUS_LOG_ONLY)
public class PyPiDeleteIndexAssetTask
extends RepositoryTaskSupport
implements Cancelable {
    private static final int ASSET_BROWSE_LIMIT = 1000;

    protected boolean appliesTo(Repository repository) {
        return "pypi".equals(repository.getFormat().getValue()) && !(repository.getType() instanceof ProxyType);
    }

    protected void execute(Repository repository) {
        ResultCount resultCount = new ResultCount();
        this.log.info("Checking indexes with MD5 checksums in PyPI repository: {}", (Object)repository.getName());
        ContentFacetSupport contentFacet = (ContentFacetSupport)repository.facet(ContentFacet.class);
        Continuation fluentAssets = contentFacet.assets().byKind(AssetKind.INDEX.name()).browse(1000, null);
        List<Object> paths = new ArrayList();
        while (!this.isCanceled() && !fluentAssets.isEmpty()) {
            paths = fluentAssets.stream().map(asset -> this.checkIndexAsset((FluentAsset)asset, resultCount)).filter(Objects::nonNull).collect(Collectors.toList());
            fluentAssets = contentFacet.assets().browse(1000, fluentAssets.nextContinuationToken());
        }
        resultCount.deleted = contentFacet.stores().assetStore.deleteAssetsByPaths(contentFacet.contentRepositoryId().intValue(), paths);
        this.log.info("Completed processing a total of {} assets. {} deleted, {} skipped and {} errors.", new Object[]{resultCount.total, resultCount.deleted, resultCount.skipped, resultCount.error});
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String checkIndexAsset(FluentAsset asset, ResultCount resultCount) {
        CancelableHelper.checkCancellation();
        ResultCount resultCount2 = resultCount;
        resultCount2.total = resultCount2.total + 1;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                BufferedReader reader;
                InputStream downloadedAsset;
                block18: {
                    String string;
                    block19: {
                        downloadedAsset = asset.download().openInputStream();
                        reader = new BufferedReader(new InputStreamReader(downloadedAsset, StandardCharsets.UTF_8));
                        if (!reader.lines().anyMatch(htmlIndex -> htmlIndex.contains("#md5="))) break block18;
                        this.log.info("Deleting the {} asset with path {}", (Object)asset.kind(), (Object)asset.path());
                        string = asset.path();
                        if (reader == null) break block19;
                        reader.close();
                    }
                    if (downloadedAsset == null) return string;
                    downloadedAsset.close();
                    return string;
                }
                try {
                    block20: {
                        this.log.info("Valid checksum present for PyPI index asset. Skipping");
                        ResultCount resultCount3 = resultCount;
                        resultCount3.skipped = resultCount3.skipped + 1;
                        break block20;
                        {
                            catch (Throwable throwable2) {
                                throw throwable2;
                            }
                        }
                        finally {
                            if (reader != null) {
                                reader.close();
                            }
                        }
                    }
                    if (downloadedAsset == null) return null;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (downloadedAsset == null) throw throwable;
                    downloadedAsset.close();
                    throw throwable;
                }
                downloadedAsset.close();
                return null;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                } else {
                    if (throwable == throwable4) throw throwable;
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.log.debug("Unexpected exception when reading the index asset download {}", (Object)e.getMessage());
            ResultCount resultCount4 = resultCount;
            resultCount4.error = resultCount4.error + 1;
        }
        return null;
    }

    public String getMessage() {
        return "Deleting index asset if MD5 Checksum is found";
    }

    private static class ResultCount {
        private int deleted;
        private int skipped;
        private int error;
        private int total;

        private ResultCount() {
        }
    }
}

