/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi.datastore.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.sonatype.nexus.repository.pypi.AssetKind;
import com.sonatype.nexus.repository.pypi.PyPiInfoUtils;
import com.sonatype.nexus.repository.pypi.PyPiPathUtils;
import com.sonatype.nexus.repository.pypi.PyPiQuarantinedVersionFacet;
import com.sonatype.nexus.repository.pypi.datastore.PyPiDataUtils;
import com.sonatype.nexus.repository.pypi.datastore.PypiContentFacet;
import com.sonatype.nexus.repository.pypi.datastore.internal.ContentPypiPathUtils;
import com.sonatype.nexus.repository.pypi.internal.PyPiFileUtils;
import com.sonatype.nexus.repository.pypi.internal.PyPiIndexUtils;
import com.sonatype.nexus.repository.pypi.internal.PyPiLink;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.sonatype.nexus.common.template.TemplateHelper;
import org.sonatype.nexus.repository.cache.CacheController;
import org.sonatype.nexus.repository.content.facet.ContentProxyFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.proxy.ProxyFacetSupport;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.ViewFacet;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

@Named
public class PyPiProxyFacet
extends ContentProxyFacetSupport {
    private final HashFunction etagDigester = Hashing.sha256();
    private final TemplateHelper templateHelper;

    @Inject
    public PyPiProxyFacet(TemplateHelper templateHelper) {
        this.templateHelper = (TemplateHelper)Preconditions.checkNotNull((Object)templateHelper);
    }

    @Nullable
    protected Content getCachedContent(Context context) {
        AssetKind assetKind = this.getAssetKind(context);
        if (assetKind.equals((Object)AssetKind.SEARCH)) {
            return null;
        }
        TokenMatcher.State state = PyPiPathUtils.matcherState(context);
        switch (assetKind) {
            case ROOT_INDEX: {
                return this.content().getAsset(ContentPypiPathUtils.indexPath()).map(FluentAsset::download).orElse(null);
            }
            case INDEX: {
                return this.rewriteIndex(PyPiPathUtils.name(state));
            }
            case PACKAGE: {
                return this.content().getAsset(PyPiPathUtils.path(state)).map(FluentAsset::download).orElse(null);
            }
        }
        throw new IllegalStateException();
    }

    @Nullable
    protected Content fetch(Context context, Content stale) throws IOException {
        try {
            return super.fetch(context, stale);
        }
        catch (ProxyFacetSupport.NonResolvablePackageException ex) {
            this.log.error("Failed to resolve package {}", (Object)ex.getMessage());
            return null;
        }
    }

    protected Content store(Context context, Content content) throws IOException {
        AssetKind assetKind = this.getAssetKind(context);
        if (assetKind.equals((Object)AssetKind.SEARCH)) {
            return content;
        }
        TokenMatcher.State state = PyPiPathUtils.matcherState(context);
        switch (assetKind) {
            case ROOT_INDEX: {
                return this.putRootIndex(content);
            }
            case INDEX: {
                String name = PyPiPathUtils.name(state);
                return this.putIndex(name, content);
            }
            case PACKAGE: {
                return this.putPackage(PyPiPathUtils.path(state), content, assetKind);
            }
        }
        throw new IllegalStateException();
    }

    protected String getUrl(@Nonnull Context context) {
        AssetKind assetKind = this.getAssetKind(context);
        if (AssetKind.PACKAGE == assetKind) {
            return this.getPackageUrl(context);
        }
        return context.getRequest().getPath().substring(1);
    }

    private Content rewriteIndex(String name) {
        Optional<FluentAsset> fluentAsset = this.content().getAsset(ContentPypiPathUtils.indexPath(name));
        if (!fluentAsset.isPresent()) {
            return null;
        }
        Content content = fluentAsset.get().download();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream inputStream = content.openInputStream();){
                List<PyPiLink> links = PyPiIndexUtils.makeIndexLinksNexusPaths(name, inputStream);
                List<PyPiLink> allowedLinks = ((PyPiQuarantinedVersionFacet)this.getRepository().facet(PyPiQuarantinedVersionFacet.class)).filterLinks(links, name);
                String truncatedPackageName = PyPiPathUtils.truncatePackageName(name);
                String html = PyPiIndexUtils.buildIndexPage(this.templateHelper, truncatedPackageName, allowedLinks);
                Content newContent = new Content((Payload)new BytesPayload(html.getBytes(), "text/html"));
                content.getAttributes().forEach(e -> {
                    Object object = newContent.getAttributes().set((String)e.getKey(), e.getValue());
                });
                this.updateEtag(newContent, html);
                return newContent;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e2) {
            this.log.warn("An error occurred re-writing the index for package {}", (Object)name, (Object)e2);
            return null;
        }
    }

    private void updateEtag(Content content, String html) {
        Hasher etagDigest = this.etagDigester.newHasher();
        etagDigest.putString((CharSequence)html, StandardCharsets.UTF_8);
        content.getAttributes().set("etag", (Object)etagDigest.hash().toString());
    }

    protected HttpRequestBase buildFetchHttpRequest(URI uri, Context context) {
        Request request = context.getRequest();
        if (PyPiPathUtils.isSearchRequest(request)) {
            Payload payload = (Payload)Preconditions.checkNotNull((Object)request.getPayload());
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (InputStream inputStream = payload.openInputStream();){
                    String type = (String)Preconditions.checkNotNull((Object)payload.getContentType());
                    ContentType contentType = ContentType.parse((String)type);
                    HttpPost post = new HttpPost(uri);
                    post.setEntity((HttpEntity)new ByteArrayEntity(IOUtils.toByteArray((InputStream)inputStream), contentType));
                    return post;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return super.buildFetchHttpRequest(uri, context);
    }

    @Nonnull
    protected CacheController getCacheController(@Nonnull Context context) {
        AssetKind assetKind = this.getAssetKind(context);
        return this.cacheControllerHolder.require(assetKind.getCacheType());
    }

    private Content putPackage(String path, Content content, AssetKind assetKind) throws IOException {
        Throwable throwable = null;
        Object var6_6 = null;
        try (TempBlob tempBlob = this.content().getTempBlob((Payload)content);){
            Map<String, String> attributes;
            Throwable throwable2 = null;
            Object var9_11 = null;
            try (InputStream is = tempBlob.get();){
                attributes = PyPiInfoUtils.extractMetadata(is);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            String filename = PyPiFileUtils.extractFilenameFromPath(path);
            if (!attributes.containsKey("name")) {
                this.log.debug("No name found in metadata for {}, extracting from the filename.", (Object)filename);
                attributes.put("name", PyPiFileUtils.extractNameFromFilename(filename));
            }
            if (!attributes.containsKey("version")) {
                this.log.debug("No version found in metadata for {}, extracting from the filename.", (Object)filename);
                attributes.put("version", PyPiFileUtils.extractVersionFromFilename(filename));
            }
            attributes.put("asset_kind", AssetKind.PACKAGE.name());
            String name = (String)Preconditions.checkNotNull((Object)attributes.get("name"));
            String version = (String)Preconditions.checkNotNull((Object)attributes.get("version"));
            FluentComponent component = this.content().findOrCreateComponent(name, version, name);
            String summary = attributes.get("summary");
            if (summary != null) {
                component.withAttribute("summary", (Object)summary);
            }
            return ((FluentAsset)this.content().saveAsset(path, component, assetKind.name(), tempBlob).markAsCached((Payload)content).withAttribute("pypi", attributes)).download();
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Content putIndex(String name, Content content) throws IOException {
        String path = ContentPypiPathUtils.indexPath(name);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream inputStream = content.openInputStream();){
                String html = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                if (!PyPiIndexUtils.validateIndexLinks(name, PyPiIndexUtils.extractLinksFromIndex(html))) {
                    return null;
                }
                PyPiIndexUtils.makeIndexLinksNexusPaths(name, inputStream);
                this.storeHtmlPage(content, html, AssetKind.INDEX, path);
                return this.rewriteIndex(name);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private Content putRootIndex(Content content) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream inputStream = content.openInputStream();){
            List<PyPiLink> links = PyPiIndexUtils.makeRootIndexRelative(inputStream);
            String indexPage = PyPiIndexUtils.buildRootIndexPage(this.templateHelper, links);
            return this.storeHtmlPage(content, indexPage, AssetKind.ROOT_INDEX, ContentPypiPathUtils.indexPath());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    private Content storeHtmlPage(Content content, String indexPage, AssetKind rootIndex, String indexPathPrefix) throws IOException {
        Throwable throwable = null;
        Object var6_7 = null;
        try {
            Content content2;
            TempBlob tempBlob;
            ByteArrayInputStream stream;
            block16: {
                block15: {
                    stream = new ByteArrayInputStream(indexPage.getBytes(StandardCharsets.UTF_8));
                    tempBlob = this.content().getTempBlob(stream, content.getContentType());
                    PyPiDataUtils.setLastModified(content);
                    content2 = ((FluentAsset)this.content().saveAsset(indexPathPrefix, rootIndex.name(), tempBlob).withAttribute("pypi", Collections.singletonMap("asset_kind", rootIndex.name()))).markAsCached((Payload)content).download();
                    if (tempBlob == null) break block15;
                    tempBlob.close();
                }
                if (stream == null) break block16;
                stream.close();
            }
            return content2;
            {
                catch (Throwable throwable2) {
                    try {
                        if (tempBlob != null) {
                            tempBlob.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (stream != null) {
                            stream.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private String getPackageUrl(Context context) {
        String filename;
        String packageName = PyPiPathUtils.packageNameFromPath(context.getRequest().getPath());
        PyPiLink link = this.getExistingPackageLink(packageName, filename = PyPiFileUtils.extractFilenameFromPath(context.getRequest().getPath())).orElseGet(() -> this.cachePackageRootMetadataAndRetrieveLink(context, packageName, filename));
        if (link == null) {
            throw new ProxyFacetSupport.NonResolvablePackageException("Unable to find reference for " + filename + " in package " + packageName);
        }
        URI remoteUrl = this.getRemoteUrl();
        if (!remoteUrl.getPath().endsWith("/")) {
            remoteUrl = URI.create(String.valueOf(remoteUrl.toString()) + "/");
        }
        remoteUrl = remoteUrl.resolve(ContentPypiPathUtils.indexUriPath(packageName));
        return remoteUrl.resolve(link.getLink()).toString();
    }

    private Optional<PyPiLink> getExistingPackageLink(String packageName, String filename) {
        Optional<FluentAsset> fluentAsset = this.content().getAsset(ContentPypiPathUtils.indexPath(packageName));
        if (!fluentAsset.isPresent()) {
            return Optional.empty();
        }
        String rootFilename = filename.endsWith(".asc") ? filename.substring(0, filename.length() - 4) : filename;
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (InputStream in = fluentAsset.get().download().openInputStream();){
                return PyPiIndexUtils.extractLinksFromIndex(in).stream().filter(link -> rootFilename.equals(link.getFile())).findFirst();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private PyPiLink cachePackageRootMetadataAndRetrieveLink(Context context, String packageName, String filename) {
        try {
            this.tryCachingPackageIndex(packageName, context);
            return this.getExistingPackageLink(packageName, filename).orElse(null);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void tryCachingPackageIndex(String packageName, Context context) throws IOException {
        try {
            Request getRequest = new Request.Builder().action("GET").path(String.valueOf('/') + ContentPypiPathUtils.indexUriPath(packageName)).build();
            Response response = ((ViewFacet)this.getRepository().facet(ViewFacet.class)).dispatch(getRequest, context);
            if (!response.getStatus().isSuccessful()) {
                this.log.debug("Could not retrieve package {}", (Object)packageName);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IOException(e);
        }
    }

    private AssetKind getAssetKind(Context context) {
        return (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
    }

    private PypiContentFacet content() {
        return (PypiContentFacet)this.getRepository().facet(PypiContentFacet.class);
    }
}

