/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi.datastore.internal;

import com.sonatype.nexus.repository.pypi.AssetKind;
import com.sonatype.nexus.repository.pypi.internal.PyPiIndexFacet;
import java.util.Set;
import javax.inject.Named;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.maintenance.LastAssetMaintenanceFacet;

@Named
public class PyPiLastAssetMaintenanceFacet
extends LastAssetMaintenanceFacet {
    public Set<String> deleteAsset(Asset asset) {
        PyPiIndexFacet facet = (PyPiIndexFacet)this.getRepository().facet(PyPiIndexFacet.class);
        facet.deleteRootIndex();
        if (this.assetKindIsPackage(asset)) {
            facet.deleteIndex((String)asset.attributes("pypi").get("name", String.class));
        }
        return super.deleteAsset(asset);
    }

    public Set<String> deleteComponent(Component component) {
        PyPiIndexFacet facet = (PyPiIndexFacet)this.getRepository().facet(PyPiIndexFacet.class);
        facet.deleteRootIndex();
        facet.deleteIndex(component.name());
        return super.deleteComponent(component);
    }

    private boolean assetKindIsPackage(Asset asset) {
        return AssetKind.PACKAGE.name().equals(asset.attributes("pypi").get("asset_kind"));
    }
}

