/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi.datastore.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.pypi.AssetKind;
import com.sonatype.nexus.repository.pypi.PyPiPathUtils;
import com.sonatype.nexus.repository.pypi.datastore.internal.ContentPypiPathUtils;
import com.sonatype.nexus.repository.pypi.datastore.internal.PyPiGroupFacet;
import com.sonatype.nexus.repository.pypi.internal.PyPiGroupUtils;
import java.util.LinkedHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.template.TemplateHelper;
import org.sonatype.nexus.repository.group.GroupHandler;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

@Named
@Singleton
class PyPiIndexGroupHandler
extends GroupHandler {
    private final TemplateHelper templateHelper;

    @Inject
    public PyPiIndexGroupHandler(TemplateHelper templateHelper) {
        this.templateHelper = (TemplateHelper)Preconditions.checkNotNull((Object)templateHelper);
    }

    protected Response doGet(@Nonnull Context context, @Nonnull GroupHandler.DispatchedRepositories dispatched) throws Exception {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)dispatched);
        AssetKind kind = (AssetKind)((Object)context.getAttributes().get(AssetKind.class));
        switch (kind) {
            case ROOT_INDEX: {
                return this.respond(this.getRootIndex(context, dispatched));
            }
            case INDEX: {
                return this.respond(this.getIndex(context, dispatched));
            }
        }
        this.log.debug("Unexpected request for kind: {}", (Object)kind);
        return HttpResponses.badRequest();
    }

    private Response respond(@Nullable Content content) {
        return content != null ? HttpResponses.ok((Payload)content) : HttpResponses.notFound();
    }

    @Nullable
    private Content getIndex(Context context, GroupHandler.DispatchedRepositories dispatched) throws Exception {
        PyPiGroupFacet groupFacet = this.group(context);
        String packageName = PyPiPathUtils.name((TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class));
        LinkedHashMap memberResponses = this.getAll(context, groupFacet.members(), dispatched);
        return groupFacet.getIndex(packageName).filter(cached -> !groupFacet.isStale((Content)cached, memberResponses)).orElseGet(() -> groupFacet.buildIndex(packageName, PyPiGroupUtils.lazyMergeResult(packageName, AssetKind.INDEX, memberResponses, this.templateHelper)));
    }

    @Nullable
    private Content getRootIndex(Context context, GroupHandler.DispatchedRepositories dispatched) throws Exception {
        String path = ContentPypiPathUtils.indexPath();
        PyPiGroupFacet groupFacet = this.group(context);
        LinkedHashMap memberResponses = this.getAll(context, groupFacet.members(), dispatched);
        return groupFacet.getRootIndex().filter(cached -> !groupFacet.isStale((Content)cached, memberResponses)).orElseGet(() -> groupFacet.buildRootIndex(PyPiGroupUtils.lazyMergeResult(path, AssetKind.ROOT_INDEX, memberResponses, this.templateHelper)));
    }

    private PyPiGroupFacet group(Context context) {
        return (PyPiGroupFacet)context.getRepository().facet(PyPiGroupFacet.class);
    }
}

