/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi.datastore.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.repository.pypi.AssetKind;
import com.sonatype.nexus.repository.pypi.datastore.PypiContentFacet;
import com.sonatype.nexus.repository.pypi.datastore.internal.ContentPypiPathUtils;
import com.sonatype.nexus.repository.pypi.internal.PyPiStorageUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.sonatype.nexus.common.cooperation2.Cooperation2;
import org.sonatype.nexus.common.cooperation2.Cooperation2Factory;
import org.sonatype.nexus.common.entity.DetachedEntityId;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.cache.RepositoryCacheInvalidationService;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.event.asset.AssetDeletedEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetPurgedEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetUploadedEvent;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.group.GroupFacetImpl;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.payloads.StringPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.validation.ConstraintViolationFactory;

@Named
@Facet.Exposed
public class PyPiGroupFacet
extends GroupFacetImpl
implements EventAware.Asynchronous {
    private Cooperation2Factory.Builder cooperationBuilder;
    private Cooperation2 indexRootCooperation;
    private PypiContentFacet contentFacet;

    @Inject
    public PyPiGroupFacet(RepositoryManager repositoryManager, ConstraintViolationFactory constraintViolationFactory, @Named(value="group") @Named(value="group") Type groupType, RepositoryCacheInvalidationService repositoryCacheInvalidationService) {
        super(repositoryManager, constraintViolationFactory, groupType, repositoryCacheInvalidationService);
    }

    @Inject
    protected void configureCooperation(Cooperation2Factory cooperationFactory, @Named(value="${nexus.pypi.indexRoot.cooperation.enabled:-true}") @Named(value="${nexus.pypi.indexRoot.cooperation.enabled:-true}") boolean cooperationEnabled, @Named(value="${nexus.pypi.indexRoot.cooperation.majorTimeout:-0s}") @Named(value="${nexus.pypi.indexRoot.cooperation.majorTimeout:-0s}") Duration majorTimeout, @Named(value="${nexus.pypi.indexRoot.cooperation.minorTimeout:-30s}") @Named(value="${nexus.pypi.indexRoot.cooperation.minorTimeout:-30s}") Duration minorTimeout, @Named(value="${nexus.pypi.indexRoot.cooperation.threadsPerKey:-100}") @Named(value="${nexus.pypi.indexRoot.cooperation.threadsPerKey:-100}") int threadsPerKey) {
        this.cooperationBuilder = cooperationFactory.configure().majorTimeout(majorTimeout).minorTimeout(minorTimeout).threadsPerKey(threadsPerKey);
    }

    @VisibleForTesting
    void buildCooperation() {
        if (Objects.nonNull(this.cooperationBuilder)) {
            this.indexRootCooperation = this.cooperationBuilder.build(String.valueOf(this.getRepository().getName()) + ":indexRoot");
        }
    }

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.contentFacet = (PypiContentFacet)this.facet(PypiContentFacet.class);
        this.buildCooperation();
    }

    public Content buildIndex(String packageName, Supplier<String> lazyMergeResult) {
        String path = ContentPypiPathUtils.indexPath(packageName);
        this.log.debug("Rebuilding index for {} in {}", (Object)packageName, (Object)this.getRepository().getName());
        Content content = this.buildMergedIndexRoot(path, lazyMergeResult);
        if (content == null) {
            return null;
        }
        if (Objects.isNull(this.indexRootCooperation)) {
            return this.putIndex(path, content);
        }
        try {
            return (Content)this.indexRootCooperation.on(() -> this.putIndex(path, content)).checkFunction(() -> this.getIndex(packageName)).cooperate(path, new String[0]);
        }
        catch (IOException | UncheckedIOException e) {
            this.log.error("Unable to use Cooperation to merge {} for repository {}", new Object[]{path, this.getRepository().getName(), e});
            return content;
        }
    }

    public Content buildRootIndex(Supplier<String> lazyMergeResult) {
        String path = ContentPypiPathUtils.indexPath();
        this.log.debug("Rebuilding root index in {}", (Object)this.getRepository().getName());
        if (Objects.isNull(this.indexRootCooperation)) {
            return this.contentFacet.putRootIndex((Payload)this.buildMergedIndexRoot(path, lazyMergeResult));
        }
        try {
            return (Content)this.indexRootCooperation.on(() -> this.contentFacet.putRootIndex((Payload)this.buildMergedIndexRoot(path, lazyMergeResult))).checkFunction(this::getRootIndex).cooperate(path, new String[0]);
        }
        catch (IOException | UncheckedIOException e) {
            this.log.error("Unable to use Cooperation to merge {} for repository {}", new Object[]{path, this.getRepository().getName(), e});
            return this.buildMergedIndexRoot(path, lazyMergeResult);
        }
    }

    protected Content buildMergedIndexRoot(String name, Supplier<String> lazyMergeResult) {
        String html = lazyMergeResult.get();
        if (html == null) {
            return null;
        }
        Content content = new Content((Payload)new StringPayload(html, "text/html"));
        this.maintainCacheInfo(content.getAttributes());
        return content;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onAssetUploadedEvent(AssetUploadedEvent event) {
        this.handleAssetEvent((AssetEvent)event, false);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onAssetDeletedEvent(AssetDeletedEvent event) {
        this.handleAssetEvent((AssetEvent)event, true);
    }

    private void handleAssetEvent(AssetEvent event, boolean delete) {
        event.getRepository().ifPresent(repository -> {
            if (this.member((Repository)repository) && (AssetKind.ROOT_INDEX.name().equals(event.getAsset().kind()) || AssetKind.INDEX.name().equals(event.getAsset().kind()))) {
                this.doInvalidateCache(event.getAsset(), delete);
            }
        });
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onAssetPurgedEvent(AssetPurgedEvent event) {
        event.getRepository().ifPresent(repository -> {
            if (!this.member((Repository)repository)) {
                return;
            }
            ContentFacet contentFacet = (ContentFacet)repository.facet(ContentFacet.class);
            int[] nArray = event.getAssetIds();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int assetId = nArray[n2];
                contentFacet.assets().find((EntityId)new DetachedEntityId(String.valueOf(assetId))).ifPresent(asset -> this.doInvalidateCache((Asset)asset, true));
                ++n2;
            }
        });
    }

    protected void doInvalidateCache(Asset asset, boolean delete) {
        this.log.info("Invalidating cached content {} from {}", (Object)asset.path(), (Object)this.getRepository().getName());
        Optional<FluentAsset> fluentAssetOpt = ((PypiContentFacet)this.getRepository().facet(PypiContentFacet.class)).getAsset(asset.path());
        fluentAssetOpt.ifPresent(fluentAsset -> {
            if (delete) {
                fluentAsset.delete();
            }
            fluentAsset.markAsStale();
        });
    }

    public Optional<Content> getIndex(String packageName) {
        return this.contentFacet.getIndex(packageName);
    }

    public Optional<Content> getRootIndex() {
        return this.contentFacet.getRootIndex();
    }

    public Content getFromCache(String name, AssetKind assetKind) {
        Preconditions.checkArgument((AssetKind.INDEX.equals((Object)assetKind) || AssetKind.ROOT_INDEX.equals((Object)assetKind) ? 1 : 0) != 0, (Object)"Only index files are cached");
        return this.contentFacet.getAsset(name).map(FluentAsset::download).orElse(null);
    }

    public boolean isStale(Content content, Map<Repository, Response> responses) {
        DateTime cacheModified = this.extractLastModified(content);
        if (cacheModified == null || this.isStale(content)) {
            return true;
        }
        for (Map.Entry<Repository, Response> response : responses.entrySet()) {
            DateTime memberLastModified;
            Content responseContent;
            Response responseValue = response.getValue();
            if (responseValue.getStatus().getCode() != 200 || (responseContent = (Content)responseValue.getPayload()) == null || (memberLastModified = (DateTime)responseContent.getAttributes().get("last_modified", DateTime.class)) != null && !memberLastModified.isAfter((ReadableInstant)cacheModified)) continue;
            Asset asset = (Asset)content.getAttributes().get(Asset.class);
            String name = asset != null ? asset.path() : "unknown";
            this.log.debug("Found stale content while fetching {} from repository {}", (Object)name, (Object)response.getKey().getName());
            return true;
        }
        return false;
    }

    private DateTime extractLastModified(Content content) {
        DateTime lastModified = content != null && content.getAttributes().contains("last_modified") ? (DateTime)content.getAttributes().get("last_modified", DateTime.class) : null;
        return lastModified;
    }

    private Content putIndex(String path, Content content) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (TempBlob blob = this.contentFacet.blobs().ingest((Payload)content, PyPiStorageUtils.HASH_ALGORITHMS);){
            return this.contentFacet.assets().path(path).kind(AssetKind.INDEX.name()).blob(blob).save().markAsCached((Payload)content).download();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

