/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi.datastore.internal;

public class ContentPypiPathUtils {
    private static final String INDEX_PATH_PREFIX = "/simple/";
    private static final String PACKAGE_PATH_PREFIX = "/packages/";

    private ContentPypiPathUtils() {
    }

    public static String packagesPath(String ... parts) {
        String pkg = String.join((CharSequence)"/", parts);
        return pkg.startsWith(PACKAGE_PATH_PREFIX) ? pkg : PACKAGE_PATH_PREFIX + pkg;
    }

    public static String indexPath() {
        return INDEX_PATH_PREFIX;
    }

    public static String indexPath(String name) {
        return INDEX_PATH_PREFIX + name + (name.endsWith("/") ? "" : "/");
    }

    public static String indexUriPath() {
        return INDEX_PATH_PREFIX.substring(1);
    }

    public static String indexUriPath(String name) {
        return ContentPypiPathUtils.buildIndexPath(name).substring(1);
    }

    private static String buildIndexPath(String name) {
        return INDEX_PATH_PREFIX + name + (name.endsWith("/") ? "" : "/");
    }

    public static boolean isIndex(String path) {
        return path.startsWith(INDEX_PATH_PREFIX);
    }

    public static boolean isRootIndexPath(String path) {
        return path.equals(INDEX_PATH_PREFIX);
    }
}

