/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi.datastore;

import com.google.common.collect.ImmutableMap;
import com.sonatype.nexus.repository.pypi.datastore.PypiContentFacet;
import com.sonatype.nexus.repository.pypi.datastore.internal.PyPiHostedFacet;
import com.sonatype.nexus.repository.pypi.internal.PyPiFileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.util.CollectionUtils;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.importtask.ImportFileConfiguration;
import org.sonatype.nexus.repository.rest.UploadDefinitionExtension;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.upload.AssetUpload;
import org.sonatype.nexus.repository.upload.ComponentUpload;
import org.sonatype.nexus.repository.upload.UploadDefinition;
import org.sonatype.nexus.repository.upload.UploadHandlerSupport;
import org.sonatype.nexus.repository.upload.UploadResponse;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.PartPayload;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.repository.view.payloads.TempBlobPartPayload;
import org.sonatype.nexus.rest.ValidationErrorsException;

@Named(value="pypi")
@Singleton
public class PyPiUploadHandler
extends UploadHandlerSupport {
    private UploadDefinition definition;
    private final ContentPermissionChecker contentPermissionChecker;
    private final VariableResolverAdapter variableResolverAdapter;

    @Inject
    public PyPiUploadHandler(ContentPermissionChecker contentPermissionChecker, @Named(value="simple") @Named(value="simple") VariableResolverAdapter variableResolverAdapter, Set<UploadDefinitionExtension> uploadDefinitionExtensions) {
        super(uploadDefinitionExtensions);
        this.contentPermissionChecker = contentPermissionChecker;
        this.variableResolverAdapter = variableResolverAdapter;
    }

    public Content handle(Repository repository, File content, String path) throws IOException {
        return this.handle(new ImportFileConfiguration(repository, content, path));
    }

    public Content handle(ImportFileConfiguration configuration) throws IOException {
        Repository repository = configuration.getRepository();
        File packageFile = configuration.getFile();
        String contentType = Files.probeContentType(packageFile.toPath());
        PypiContentFacet contentFacet = (PypiContentFacet)repository.facet(PypiContentFacet.class);
        Throwable throwable = null;
        Object var7_8 = null;
        try (TempBlob blob = contentFacet.blobs().ingest(packageFile.toPath(), contentType, PypiContentFacet.HASHING, configuration.isHardLinkingEnabled());){
            if (configuration.getFile().getName().endsWith(".asc")) {
                return this.importSignatureFile(configuration, blob, contentType);
            }
            return this.importPackageFile(configuration, blob, contentType);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Content importPackageFile(ImportFileConfiguration configuration, TempBlob tempBlob, String contentType) throws IOException {
        PyPiHostedFacet facet = (PyPiHostedFacet)configuration.getRepository().facet(PyPiHostedFacet.class);
        Map<String, String> metadata = this.getAndValidateMetadata(facet, tempBlob);
        String name = this.getAndValidateName(metadata);
        return facet.upload(configuration.getFile().getName(), metadata, new TempBlobPartPayload("", false, name, contentType, tempBlob));
    }

    private Content importSignatureFile(ImportFileConfiguration configuration, TempBlob tempBlob, String contentType) throws IOException {
        Repository repository = configuration.getRepository();
        PyPiHostedFacet facet = (PyPiHostedFacet)repository.facet(PyPiHostedFacet.class);
        String assetName = configuration.getAssetName();
        String name = PyPiFileUtils.extractNameFromPath(assetName);
        String version = PyPiFileUtils.extractVersionFromPath(assetName);
        String path = StringUtils.prependIfMissing((String)assetName, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        this.ensurePermitted(repository.getName(), "pypi", path, (Map)ImmutableMap.of((Object)"name", (Object)name, (Object)"version", (Object)version));
        return facet.uploadSignature(name, version, new TempBlobPartPayload("", false, name, contentType, tempBlob));
    }

    public UploadResponse handle(Repository repository, ComponentUpload upload) throws IOException {
        PyPiHostedFacet facet = (PyPiHostedFacet)repository.facet(PyPiHostedFacet.class);
        PypiContentFacet contentFacet = (PypiContentFacet)repository.facet(PypiContentFacet.class);
        PartPayload payload = ((AssetUpload)upload.getAssetUploads().get(0)).getPayload();
        Throwable throwable = null;
        Object var7_8 = null;
        try (TempBlob tempBlob = contentFacet.getTempBlob((Payload)payload);){
            Map<String, String> metadata = this.getAndValidateMetadata(facet, tempBlob);
            String name = this.getAndValidateName(metadata);
            String version = this.getAndValidateVersion(metadata);
            String filename = StringUtils.isNotBlank((CharSequence)payload.getName()) ? payload.getName() : String.valueOf(name) + '-' + version + '.' + metadata.get("archive_type");
            String path = facet.createPackagePath(name, version, filename);
            String pathWithPrefix = StringUtils.prependIfMissing((String)path, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
            this.ensurePermitted(repository.getName(), "pypi", pathWithPrefix, this.coordinatesFromMetadata(metadata));
            Content content = facet.upload(filename, metadata, new TempBlobPartPayload(payload, tempBlob));
            return new UploadResponse(Collections.singletonList(content), Collections.singletonList(path));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Map<String, String> getAndValidateMetadata(PyPiHostedFacet facet, TempBlob blob) throws IOException {
        Map<String, String> metadata = facet.extractMetadata(blob);
        if (CollectionUtils.isEmpty(metadata)) {
            throw new ValidationErrorsException("Unable to extract PyPI metadata from provided archive.");
        }
        return metadata;
    }

    private String getAndValidateName(Map<String, String> metadata) {
        String name = metadata.get("name");
        if (Strings2.isBlank((String)name)) {
            throw new ValidationErrorsException("Metadata is missing the name attribute");
        }
        return name;
    }

    private String getAndValidateVersion(Map<String, String> metadata) {
        String version = metadata.get("version");
        if (Strings2.isBlank((String)version)) {
            throw new ValidationErrorsException("Metadata is missing the version attribute");
        }
        return version;
    }

    private Map<String, String> coordinatesFromMetadata(Map<String, String> packageMetadata) {
        return ImmutableMap.of((Object)"name", (Object)packageMetadata.get("name"), (Object)"version", (Object)packageMetadata.get("version"));
    }

    public UploadDefinition getDefinition() {
        if (this.definition == null) {
            this.definition = this.getDefinition("pypi", false);
        }
        return this.definition;
    }

    public VariableResolverAdapter getVariableResolverAdapter() {
        return this.variableResolverAdapter;
    }

    public ContentPermissionChecker contentPermissionChecker() {
        return this.contentPermissionChecker;
    }

    public boolean supportsExportImport() {
        return true;
    }
}

