/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi.datastore;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.sonatype.nexus.repository.pypi.AssetKind;
import com.sonatype.nexus.repository.pypi.PyPiAttributes;
import com.sonatype.nexus.repository.pypi.internal.PyPiStorageUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentAttributes;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.view.Content;

public class PyPiDataUtils {
    public static final String P_ASSET_KIND = "asset_kind";

    public static Map<String, Object> getComponentPackageFormatAttributes(String name, String version, String summary) {
        Map<String, String> nameAttributes = PyPiStorageUtils.getNameAttributes(name);
        HashMap<String, Object> formatAttributes = new HashMap<String, Object>(nameAttributes);
        formatAttributes.put("summary", summary);
        formatAttributes.put("version", version);
        return formatAttributes;
    }

    public static Map<String, Object> getAssetPackageFormatAttributes(Map<String, String> attributes) {
        HashMap<String, Object> formatAttributes = new HashMap<String, Object>();
        for (String attribute : PyPiAttributes.SUPPORTED_ATTRIBUTES) {
            String value = Strings.nullToEmpty((String)attributes.get(attribute)).trim();
            if (value.isEmpty()) continue;
            formatAttributes.put(attribute, value);
        }
        formatAttributes.put(P_ASSET_KIND, AssetKind.PACKAGE.name());
        return formatAttributes;
    }

    public static void copyFormatAttributes(FluentAsset asset, Map<String, String> attributes) {
        Preconditions.checkNotNull((Object)asset);
        Preconditions.checkNotNull(attributes);
        HashMap<String, String> formatAttributes = (HashMap<String, String>)asset.attributes().get("pypi");
        if (formatAttributes == null) {
            formatAttributes = new HashMap<String, String>();
        }
        for (String attribute : PyPiAttributes.SUPPORTED_ATTRIBUTES) {
            String value = Strings.nullToEmpty((String)attributes.get(attribute)).trim();
            if (value.isEmpty()) continue;
            formatAttributes.put(attribute, value);
        }
        asset.withAttribute("pypi", formatAttributes);
    }

    public static void setFormatAttribute(FluentAsset asset, String key, Object value) {
        Preconditions.checkNotNull((Object)asset);
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)value);
        PyPiDataUtils.setFormatAttribute((FluentAttributes)asset, (Map)asset.attributes().get("pypi"), key, value);
    }

    public static void setFormatAttribute(FluentComponent component, String key, Object value) {
        Preconditions.checkNotNull((Object)component);
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)value);
        PyPiDataUtils.setFormatAttribute((FluentAttributes)component, (Map)component.attributes().get("pypi"), key, value);
    }

    public static void setFormatAttribute(FluentAttributes fluentAttributes, @Nullable Map<String, Object> formatAttributes, String key, Object value) {
        if (formatAttributes == null) {
            formatAttributes = new HashMap<String, Object>();
        }
        formatAttributes.put(key, value);
        fluentAttributes.withAttribute("pypi", formatAttributes);
    }

    public static void setLastModified(Content content) {
        if (!content.getAttributes().contains("last_modified")) {
            content.getAttributes().set("last_modified", (Object)DateTime.now());
        }
    }

    public static Optional<String> getMd5(FluentAsset asset) {
        Preconditions.checkNotNull((Object)asset);
        return asset.blob().map(b -> (String)b.checksums().get(HashAlgorithm.MD5.name()));
    }

    public static Optional<String> getSha256(FluentAsset asset) {
        Preconditions.checkNotNull((Object)asset);
        return asset.blob().map(b -> (String)b.checksums().get(HashAlgorithm.SHA256.name()));
    }
}

