/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.firewall.QuarantinedVersionFacetSupport;
import com.sonatype.nexus.repository.pypi.PyPiPathUtils;
import com.sonatype.nexus.repository.pypi.internal.PyPiFileUtils;
import com.sonatype.nexus.repository.pypi.internal.PyPiLink;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.audit.AuditData;
import org.sonatype.nexus.audit.AuditRecorder;
import org.sonatype.nexus.cache.CacheManager;
import org.sonatype.nexus.cache.NexusCache;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.firewall.event.QuarantineComponentsRequestEvent;

@Facet.Exposed
@Named
public class PyPiQuarantinedVersionFacet
extends QuarantinedVersionFacetSupport {
    public static final String REMOVE_QUARANTINED_KEY = "removeQuarantinedVersions";
    public static final String CACHE_NAME = "FIREWALL_ALLOWED_PYPI_LINKS";
    private final EventManager eventManager;
    private final int quarantinedVersionsTimeoutInSeconds;
    private final AuditRecorder auditRecorder;
    private final CacheManager<String, Package> cacheManager;
    private volatile NexusCache<String, Package> allowedPyPiLinksCache;
    private final ReentrantReadWriteLock allowedPyPiLinksCacheLock = new ReentrantReadWriteLock();

    @Inject
    protected PyPiQuarantinedVersionFacet(CapabilityRegistry capabilityRegistry, @Named(value="${nexus.pypi.firewall.quarantined_versions_timeout_seconds:-30}") @Named(value="${nexus.pypi.firewall.quarantined_versions_timeout_seconds:-30}") int quarantinedVersionsTimeoutInSeconds, EventManager eventManager, CacheManager<String, Package> cacheManager, AuditRecorder auditRecorder) {
        super(capabilityRegistry);
        Preconditions.checkArgument((quarantinedVersionsTimeoutInSeconds > 0 ? 1 : 0) != 0, (String)"nexus.pypi.firewall.quarantined_versions_timeout must be > 0. Value was %d", (int)quarantinedVersionsTimeoutInSeconds);
        this.quarantinedVersionsTimeoutInSeconds = quarantinedVersionsTimeoutInSeconds;
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.cacheManager = (CacheManager)Preconditions.checkNotNull(cacheManager);
        this.auditRecorder = (AuditRecorder)Preconditions.checkNotNull((Object)auditRecorder);
    }

    public List<PyPiLink> filterLinks(List<PyPiLink> pyPiLinks, String packageName) {
        Repository repository = this.getRepository();
        Boolean removeQuarantinedVersions = (Boolean)repository.getConfiguration().attributes("pypi").get(REMOVE_QUARANTINED_KEY, Boolean.class);
        if (!Boolean.TRUE.equals(removeQuarantinedVersions) || !this.isFirewallEnabled()) {
            return pyPiLinks;
        }
        return this.getAllowedPypiLinks(pyPiLinks, packageName, repository);
    }

    private List<PyPiLink> getAllowedPypiLinks(List<PyPiLink> pyPiLinks, String packageName, Repository repository) {
        ArrayList<PyPiLink> allowedPyPiLinks = new ArrayList<PyPiLink>();
        try {
            Optional<List<PyPiLink>> cachedAllowedVersionsOpt = this.getAllowedPyPiLinksFromCache(packageName);
            if (cachedAllowedVersionsOpt.isPresent()) {
                return pyPiLinks.stream().filter(pyPiLink -> ((List)cachedAllowedVersionsOpt.get()).contains(pyPiLink)).collect(Collectors.toList());
            }
            List<QuarantineComponentsRequestEvent.FirewallComponent> components = PyPiQuarantinedVersionFacet.buildFirewallComponents(pyPiLinks, packageName);
            QuarantineComponentsRequestEvent request = new QuarantineComponentsRequestEvent(repository, components);
            this.eventManager.post((Object)request);
            HashSet quarantinedPaths = new HashSet((Collection)request.getResult().get(this.quarantinedVersionsTimeoutInSeconds, TimeUnit.SECONDS));
            ArrayList<PyPiLink> quarantinedPyPiLinks = new ArrayList<PyPiLink>();
            for (PyPiLink pyPiLink2 : pyPiLinks) {
                if (quarantinedPaths.contains(PyPiQuarantinedVersionFacet.getPath(pyPiLink2, packageName))) {
                    quarantinedPyPiLinks.add(pyPiLink2);
                    continue;
                }
                allowedPyPiLinks.add(pyPiLink2);
            }
            this.putAllowedPyPiLinksInCache(packageName, allowedPyPiLinks);
            if (!quarantinedPyPiLinks.isEmpty()) {
                this.log.info("Filtering quarantined pypi links for packageName {} metadata:{}", (Object)packageName, quarantinedPyPiLinks);
                this.auditQuarantinedPypiLinks(repository.getName(), packageName, quarantinedPyPiLinks);
            }
            return allowedPyPiLinks;
        }
        catch (InterruptedException e) {
            this.log.error("Interrupted while getting allowed pypi links for name '{}'", (Object)packageName, (Object)e);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException | TimeoutException e) {
            this.log.error("Error getting allowed pypi links for name '{}'", (Object)packageName, (Object)e);
            throw new RuntimeException(e);
        }
        return allowedPyPiLinks;
    }

    private static List<QuarantineComponentsRequestEvent.FirewallComponent> buildFirewallComponents(List<PyPiLink> pyPiLinks, String packageName) {
        return pyPiLinks.stream().map(pyPiLink -> new QuarantineComponentsRequestEvent.FirewallComponent(null, PyPiQuarantinedVersionFacet.getPath(pyPiLink, packageName), PyPiQuarantinedVersionFacet.getVersion(pyPiLink))).collect(Collectors.toList());
    }

    private static String getPath(PyPiLink pyPiLink, String packageName) {
        String filename = pyPiLink.getFile();
        String version = PyPiFileUtils.extractVersionFromFilename(filename);
        return PyPiPathUtils.packagesPath(packageName, version, filename);
    }

    private static String getVersion(PyPiLink pyPiLink) {
        String filename = pyPiLink.getFile();
        return PyPiFileUtils.extractVersionFromFilename(filename);
    }

    protected String getCacheName() {
        return String.valueOf(this.getRepository().getName()) + "-" + CACHE_NAME;
    }

    private void auditQuarantinedPypiLinks(String repository, String packageName, List<PyPiLink> quarantinedPyPiLinks) {
        AuditData auditData = new AuditData();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("repository.name", repository);
        attributes.put("format", "pypi");
        attributes.put("package.name", packageName);
        attributes.put("vulnerable.components.list", quarantinedPyPiLinks);
        auditData.setAttributes(attributes);
        auditData.setContext("Filtering quarantined versions");
        auditData.setDomain("PyPI Quarantine");
        auditData.setTimestamp(new Date());
        this.auditRecorder.record(auditData);
    }

    public Optional<List<PyPiLink>> getAllowedPyPiLinksFromCache(String name) {
        this.allowedPyPiLinksCacheLock.readLock().lock();
        try {
            this.maybeCreateCache();
            Optional<List<PyPiLink>> optional = this.allowedPyPiLinksCache.get((Object)name).map(Package::getAllowedPypiLinks);
            return optional;
        }
        finally {
            this.allowedPyPiLinksCacheLock.readLock().unlock();
        }
    }

    public void putAllowedPyPiLinksInCache(String name, List<PyPiLink> allowedPypiLinks) {
        this.allowedPyPiLinksCacheLock.writeLock().lock();
        try {
            this.maybeCreateCache();
            this.allowedPyPiLinksCache.put((Object)name, (Object)new Package(allowedPypiLinks));
        }
        finally {
            this.allowedPyPiLinksCacheLock.writeLock().unlock();
        }
    }

    private void maybeCreateCache() {
        if (this.allowedPyPiLinksCache == null) {
            this.log.debug("Creating {} cache for: {}", (Object)CACHE_NAME, (Object)this.getRepository());
            this.allowedPyPiLinksCache = this.cacheManager.getCache(this.getCacheName(), String.class, Package.class, this.getCacheDuration());
            this.log.debug("Created {} cache for: {}", (Object)CACHE_NAME, (Object)this.getRepository());
        }
    }

    protected void destroyCache() {
        if (this.allowedPyPiLinksCache != null) {
            this.log.debug("Destroying {} cache for: {}", (Object)CACHE_NAME, (Object)this.getRepository());
            this.allowedPyPiLinksCache.removeAll();
            this.cacheManager.destroyCache(this.getCacheName());
            this.allowedPyPiLinksCache = null;
            this.log.debug("Destroyed {} cache for: {}", (Object)CACHE_NAME, (Object)this.getRepository());
        }
    }

    static final class Package {
        private List<PyPiLink> allowedPypiLinks;

        public Package() {
        }

        public Package(List<PyPiLink> allowedPypiLinks) {
            this.allowedPypiLinks = allowedPypiLinks;
        }

        public List<PyPiLink> getAllowedPypiLinks() {
            return this.allowedPypiLinks;
        }
    }
}

