/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.pypi.datastore.internal.ContentPypiPathUtils;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

public final class PyPiPathUtils {
    public static final String INDEX_PATH_PREFIX = "simple/";
    public static final String PACKAGE_PATH_PREFIX = "packages/";
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("\\/?packages\\/(?<packageName>[^/]+)\\/.*");

    public static boolean isSearchRequest(Request request) {
        return "POST".equals(request.getAction()) && request.getPath().endsWith("/pypi");
    }

    public static TokenMatcher.State matcherState(Context context) {
        return (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
    }

    public static String name(TokenMatcher.State state) {
        return PyPiPathUtils.match(state, "name");
    }

    public static String path(TokenMatcher.State state) {
        return PyPiPathUtils.match(state, "path");
    }

    private static String match(TokenMatcher.State state, String name) {
        Preconditions.checkNotNull((Object)state);
        String result = (String)state.getTokens().get(name);
        Preconditions.checkNotNull((Object)result);
        return result;
    }

    public static String indexPath(String name) {
        return INDEX_PATH_PREFIX + name + (name.endsWith("/") ? "" : "/");
    }

    public static String packagesPath(String ... parts) {
        String pkg = String.join((CharSequence)"/", parts);
        return pkg.startsWith(PACKAGE_PATH_PREFIX) ? pkg : PACKAGE_PATH_PREFIX + pkg;
    }

    public static String packageNameFromPath(String path) {
        Matcher m = PACKAGE_PATTERN.matcher(path);
        if (m.matches()) {
            return m.group("packageName");
        }
        return null;
    }

    public static String normalizeName(String name) {
        return name.replaceAll("[\\-\\_\\.]+", "-").toLowerCase(Locale.ENGLISH);
    }

    public static String normalizeName(String name, String replace) {
        return name.replaceAll("[\\-\\_\\.]+", replace).toLowerCase(Locale.ENGLISH);
    }

    public static boolean isRootIndexPath(String path) {
        return path.equals(INDEX_PATH_PREFIX);
    }

    public static boolean isIndexPath(String path) {
        return path.startsWith(INDEX_PATH_PREFIX);
    }

    public static String createPackagePath(String name, String version, String filename) {
        String normalizedName = PyPiPathUtils.normalizeName(name);
        return ContentPypiPathUtils.packagesPath(normalizedName, version, filename);
    }

    public static String truncatePackageName(String name) {
        return name.substring(name.indexOf(47) + 1);
    }

    private PyPiPathUtils() {
    }
}

