/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharStreams;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.mail.Header;
import javax.mail.internet.InternetHeaders;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PyPiInfoUtils {
    private static final Logger log = LoggerFactory.getLogger(PyPiInfoUtils.class);
    private static final Map<String, String> NAME_SUBSTITUTIONS = new ImmutableMap.Builder().put((Object)"classifier", (Object)"classifiers").build();

    /*
     * Unable to fully structure code
     */
    public static Map<String, String> extractMetadata(InputStream is) {
        Preconditions.checkNotNull((Object)is);
        exceptions = new HashMap<String, Exception>();
        try {
            compressionType = CompressorStreamFactory.detect((InputStream)is);
            var3_7 = null;
            var4_11 = null;
            try {
                cis = CompressorStreamFactory.getSingleton().createCompressorInputStream(compressionType, is);
                try {
                    decompressedInput = new BufferedInputStream((InputStream)cis);
                    archiveType = ArchiveStreamFactory.detect((InputStream)decompressedInput);
                    metadata = PyPiInfoUtils.extractMetadataFromArchive(archiveType, decompressedInput);
                    metadata.put("archive_type", String.valueOf(archiveType) + '.' + compressionType);
                    return metadata;
                }
                finally {
                    if (cis != null) {
                        cis.close();
                    }
                }
            }
            catch (Throwable var4_12) {
                if (var3_7 == null) {
                    var3_7 = var4_12;
                } else if (var3_7 != var4_12) {
                    var3_7.addSuppressed(var4_12);
                }
                throw var3_7;
            }
        }
        catch (Exception e) {
            exceptions.put("Unable to decompress PyPI archive", e);
            try {
                archiveType = ArchiveStreamFactory.detect((InputStream)is);
                metadata = PyPiInfoUtils.extractMetadataFromArchive(archiveType, is);
                metadata.put("archive_type", archiveType);
                return metadata;
            }
            catch (Exception e) {
                exceptions.put("Unable to extract PyPI archive", e);
                ** for (entry : exceptions.entrySet())
            }
        }
lbl-1000:
        // 1 sources

        {
            PyPiInfoUtils.log.error((String)entry.getKey(), (Throwable)entry.getValue());
            continue;
        }
lbl43:
        // 1 sources

        return new LinkedHashMap<String, String>();
    }

    private static Map<String, String> extractMetadataFromArchive(String archiveType, InputStream is) throws Exception {
        Preconditions.checkNotNull((Object)archiveType);
        Preconditions.checkNotNull((Object)is);
        ArchiveStreamFactory archiveFactory = new ArchiveStreamFactory();
        Throwable throwable = null;
        Object var4_5 = null;
        try (ArchiveInputStream ais = archiveFactory.createArchiveInputStream(archiveType, is);){
            return PyPiInfoUtils.processArchiveEntries(ais);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static Map<String, String> processArchiveEntries(ArchiveInputStream ais) throws Exception {
        Preconditions.checkNotNull((Object)ais);
        ArchiveEntry entry = ais.getNextEntry();
        while (entry != null) {
            if (PyPiInfoUtils.isMetadataFile(entry)) {
                LinkedHashMap<String, String> results = new LinkedHashMap<String, String>();
                for (Map.Entry<String, List<String>> attribute : PyPiInfoUtils.parsePackageInfo((InputStream)ais).entrySet()) {
                    results.put(attribute.getKey(), String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)attribute.getValue()));
                }
                return results;
            }
            entry = ais.getNextEntry();
        }
        return new LinkedHashMap<String, String>();
    }

    public static String parseExtension(String fileName) {
        int extensionStart = PyPiInfoUtils.getExtensionStart(fileName);
        return fileName.substring(extensionStart + 1);
    }

    private static int getExtensionStart(String fileName) {
        int extensionStart = fileName.lastIndexOf(46);
        if (extensionStart >= 4 && ".tar".equals(fileName.substring(extensionStart - 4, extensionStart))) {
            extensionStart -= 4;
        }
        return extensionStart;
    }

    public static Optional<String> parseQualifier(String fileName, String version) {
        int extensionStart = PyPiInfoUtils.getExtensionStart(fileName);
        int versionStart = fileName.indexOf(version);
        if (versionStart >= 0) {
            int versionEnd = versionStart + version.length();
            String qualifier = versionEnd >= extensionStart ? "" : fileName.substring(versionEnd + 1, extensionStart);
            return Optional.of(qualifier);
        }
        return Optional.empty();
    }

    public static String parseFileName(String path) {
        Preconditions.checkNotNull((Object)path);
        return path.substring(path.lastIndexOf(47) + 1);
    }

    @VisibleForTesting
    static Map<String, List<String>> parsePackageInfo(InputStream in) throws Exception {
        String text;
        Preconditions.checkNotNull((Object)in);
        LinkedHashMap<String, List<String>> results = new LinkedHashMap<String, List<String>>();
        InternetHeaders headers = new InternetHeaders(in);
        Enumeration headerEnumeration = headers.getAllHeaders();
        while (headerEnumeration.hasMoreElements()) {
            Header header = (Header)headerEnumeration.nextElement();
            String underscoreName = header.getName().toLowerCase().replace('-', '_');
            String name = NAME_SUBSTITUTIONS.getOrDefault(underscoreName, underscoreName);
            String value = PyPiInfoUtils.convertHeaderValue(header.getValue());
            if (!results.containsKey(name)) {
                results.put(name, new ArrayList());
            }
            results.get(name).add(value);
        }
        if (!results.containsKey("description") && !(text = Strings.nullToEmpty((String)CharStreams.toString((Readable)new InputStreamReader(in, StandardCharsets.UTF_8))).trim()).isEmpty()) {
            ArrayList<String> description = new ArrayList<String>();
            description.add(String.valueOf(text.replace("\r\n", "\n").replaceAll("[ ]*\\n[ ]*", "\n").replaceAll("(?<!\\\\)\\\\u0000", "")) + "\n");
            results.put("description", description);
        }
        return results;
    }

    private static String convertHeaderValue(String value) {
        if (value == null || value.trim().isEmpty()) {
            return "";
        }
        return new String(value.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8).replace("\r\n", "\n").replaceAll("[ ]*\\n[ ]*", "\n");
    }

    private static boolean isMetadataFile(ArchiveEntry entry) {
        Preconditions.checkNotNull((Object)entry);
        if (entry.isDirectory()) {
            return false;
        }
        String[] parts = entry.getName().split("/");
        return PyPiInfoUtils.isEggInfoPath(parts) || PyPiInfoUtils.isPackageInfoFilePath(parts) || PyPiInfoUtils.isMetadataFilePath(parts);
    }

    private static boolean isEggInfoPath(String[] parts) {
        Preconditions.checkNotNull((Object)parts);
        if (parts.length == 2 && "EGG-INFO".equals(parts[1])) {
            return true;
        }
        if (parts.length == 1) {
            return "EGG-INFO".equals(parts[0]) || parts[0].endsWith(".egg-info");
        }
        return false;
    }

    private static boolean isMetadataFilePath(String[] parts) {
        Preconditions.checkNotNull((Object)parts);
        return parts.length == 2 && parts[0].endsWith(".dist-info") && "METADATA".equals(parts[1]);
    }

    private static boolean isPackageInfoFilePath(String[] parts) {
        Preconditions.checkNotNull((Object)parts);
        if (parts.length == 3 && parts[1].endsWith(".egg-info") && "PKG-INFO".equals(parts[2])) {
            return true;
        }
        if (parts.length == 2 && "EGG-INFO".equals(parts[0]) && "PKG-INFO".equals(parts[1])) {
            return true;
        }
        return parts.length == 2 && "PKG-INFO".equals(parts[1]);
    }

    private PyPiInfoUtils() {
    }
}

