/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.restore.pypi.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.pypi.AssetKind;
import com.sonatype.nexus.repository.pypi.PyPiInfoUtils;
import com.sonatype.nexus.repository.pypi.PyPiPathUtils;
import com.sonatype.nexus.repository.pypi.PyPiRestoreUtil;
import com.sonatype.nexus.repository.pypi.datastore.PyPiDataUtils;
import com.sonatype.nexus.repository.pypi.datastore.PypiContentFacet;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.restore.datastore.BaseRestoreBlobStrategy;
import org.sonatype.nexus.blobstore.restore.datastore.DataStoreRestoreBlobData;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.DetachedBlobPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

@FeatureFlag(name="nexus.datastore.enabled")
@Named(value="pypi")
@Singleton
public class PyPiRestoreBlobStrategy
extends BaseRestoreBlobStrategy<DataStoreRestoreBlobData> {
    private final RepositoryManager repositoryManager;

    @Inject
    public PyPiRestoreBlobStrategy(DryRunPrefix dryRunPrefix, RepositoryManager repositoryManager) {
        super(dryRunPrefix);
        this.repositoryManager = repositoryManager;
    }

    protected boolean canAttemptRestore(@Nonnull DataStoreRestoreBlobData data) {
        Repository repository = data.getRepository();
        if (!repository.optionalFacet(PypiContentFacet.class).isPresent()) {
            this.log.warn("Skipping as PyPI Facet not found on repository: {}", (Object)repository.getName());
            return false;
        }
        return true;
    }

    protected void createAssetFromBlob(Blob assetBlob, DataStoreRestoreBlobData data) throws IOException {
        PypiContentFacet pypiContentFacet = (PypiContentFacet)data.getRepository().facet(PypiContentFacet.class);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = pypiContentFacet.getTempBlob((Payload)new DetachedBlobPayload(assetBlob));){
            if (this.isComponentRequired(data)) {
                Map<String, String> attributes = this.getAttributes(tempBlob);
                String name = (String)Preconditions.checkNotNull((Object)attributes.get("name"));
                String version = (String)Preconditions.checkNotNull((Object)attributes.get("version"));
                String normalizedName = PyPiPathUtils.normalizeName(name);
                FluentComponent component = pypiContentFacet.findOrCreateComponent(name, version, normalizedName);
                PyPiDataUtils.setFormatAttribute(component, "summary", (Object)attributes.get("summary"));
                PyPiDataUtils.setFormatAttribute(component, "version", (Object)version);
                FluentAsset asset = pypiContentFacet.saveAsset(data.getBlobName(), component, AssetKind.PACKAGE.name(), tempBlob);
                PyPiDataUtils.setFormatAttribute(asset, "asset_kind", (Object)AssetKind.PACKAGE.name());
                PyPiDataUtils.copyFormatAttributes(asset, attributes);
            } else {
                AssetKind metadataAssetKind = PyPiRestoreUtil.isRootIndex(data.getBlobName()) ? AssetKind.ROOT_INDEX : AssetKind.INDEX;
                pypiContentFacet.saveAsset(data.getBlobName(), metadataAssetKind.name(), tempBlob);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Map<String, String> getAttributes(TempBlob tempBlob) {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (InputStream inputStream = tempBlob.get();){
                return PyPiInfoUtils.extractMetadata(inputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            this.log.warn("Skipping invalid pypi package blob: {}", (Object)tempBlob.getBlob().getId());
            return Collections.emptyMap();
        }
    }

    protected String getAssetPath(@Nonnull DataStoreRestoreBlobData data) {
        return data.getBlobName();
    }

    protected DataStoreRestoreBlobData createRestoreData(Properties properties, Blob blob, BlobStore blobStore) {
        return new DataStoreRestoreBlobData(blob, properties, blobStore, this.repositoryManager);
    }

    protected boolean isComponentRequired(DataStoreRestoreBlobData data) {
        return !PyPiRestoreUtil.isIndex(data.getBlobName());
    }

    public void after(boolean updateAssets, Repository repository) {
    }
}

