/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.api.ext.tasks;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.api.ext.tasks.ScheduleHelper;
import com.sonatype.nexus.api.ext.tasks.TaskTemplateValidator;
import com.sonatype.nexus.api.ext.tasks.TaskTemplateXO;
import com.sonatype.nexus.api.ext.tasks.doc.TasksApiResourceDocPro;
import java.util.AbstractMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.groups.Default;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.rest.ValidationErrorsException;
import org.sonatype.nexus.rest.WebApplicationMessageException;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskDescriptor;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.schedule.Schedule;
import org.sonatype.nexus.validation.Validate;
import org.sonatype.nexus.validation.group.Create;
import org.sonatype.nexus.validation.group.Update;

@Named
@Singleton
@Path(value="/v1/tasks")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class TasksApiResourcePro
extends ComponentSupport
implements Resource,
TasksApiResourceDocPro {
    public static final String RESOURCE_URI = "/v1/tasks";
    public static final String TEMPLATES_URI = "/templates";
    public static final String TASK_NOT_FOUND = "Task id=%s not found";
    public static final String TASK_IS_RUNNING = "Task %s id=%s is running and cannot be deleted";
    private final ScheduleHelper scheduleHelper;
    private final TaskScheduler taskScheduler;
    private final TaskTemplateValidator taskTemplateValidator;
    private final boolean allowScriptCreation;

    @Inject
    public TasksApiResourcePro(TaskScheduler taskScheduler, ScheduleHelper scheduleHelper, @Named(value="${nexus.scripts.allowCreation:-false}") @Named(value="${nexus.scripts.allowCreation:-false}") boolean allowScriptCreation, TaskTemplateValidator taskTemplateValidator) {
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
        this.scheduleHelper = (ScheduleHelper)Preconditions.checkNotNull((Object)scheduleHelper);
        this.allowScriptCreation = allowScriptCreation;
        this.taskTemplateValidator = (TaskTemplateValidator)Preconditions.checkNotNull((Object)taskTemplateValidator);
    }

    @Override
    @GET
    @Path(value="/templates")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:tasks:read"})
    @Timed
    public List<TaskTemplateXO> getTaskTemplates() {
        return this.taskScheduler.getTaskFactory().getDescriptors().stream().map(TaskTemplateXO::toTaskTemplateXO).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    @DELETE
    @Path(value="{id}")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:tasks:delete"})
    @Timed
    public Response deleteTaskById(@PathParam(value="id") String taskId) {
        TaskInfo taskInfo = this.taskScheduler.getTaskById(taskId);
        if (taskInfo == null) {
            throw new WebApplicationMessageException(Response.Status.NOT_FOUND, (Object)String.format("Task '%s' not found", taskId), "application/json");
        }
        boolean result = taskInfo.remove();
        if (!result) {
            throw new WebApplicationMessageException(Response.Status.CONFLICT, (Object)String.format(TASK_IS_RUNNING, taskInfo.getName(), taskId), "application/json");
        }
        return Response.noContent().build();
    }

    @Override
    @GET
    @Path(value="/templates/{typeId}")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:tasks:read"})
    @Timed
    public TaskTemplateXO getTaskTemplate(@PathParam(value="typeId") String typeId) {
        TaskDescriptor taskDescriptor = this.taskScheduler.getTaskFactory().getDescriptors().stream().filter(descriptor -> descriptor.getId().equals(typeId)).findAny().orElseThrow(() -> new WebApplicationMessageException(Response.Status.NOT_FOUND, (Object)String.format("No task template found for type '%s'", typeId), "application/json"));
        return TaskTemplateXO.toTaskTemplateXO(taskDescriptor);
    }

    @Override
    @PUT
    @Path(value="/{taskId}")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:tasks:update"})
    @Validate(groups={Update.class, Default.class})
    @Timed
    public void updateTask(@PathParam(value="taskId") String taskId, @NotNull @Valid TaskTemplateXO taskXO) {
        TaskInfo taskInfo = this.taskScheduler.getTaskById(taskId);
        if (taskInfo == null) {
            throw new WebApplicationMessageException(Response.Status.NOT_FOUND, (Object)String.format("Task '%s' not found", taskId), "application/json");
        }
        this.taskTemplateValidator.checkValid(taskXO, taskInfo);
        if (taskInfo.getCurrentState().getState().isRunning()) {
            throw new WebApplicationMessageException(Response.Status.CONFLICT, (Object)"Task cannot be edited while it is being executed or it is in line to be executed", "application/json");
        }
        if (taskInfo.getTypeId().equals("scripts")) {
            String originalSource = taskInfo.getConfiguration().getString("source");
            String updateSource = taskXO.getProperties().get("source");
            if (!this.allowScriptCreation && originalSource != null && !originalSource.equals(updateSource)) {
                throw new ValidationErrorsException("Script source updates are not allowed");
            }
        }
        TaskConfiguration taskConfiguration = this.taskScheduler.createTaskConfigurationInstance(taskInfo.getTypeId());
        taskConfiguration.apply(taskInfo.getConfiguration());
        taskConfiguration.setEnabled(taskXO.getEnabled().booleanValue());
        taskConfiguration.setName(taskXO.getName());
        taskConfiguration.setAlertEmail(taskXO.getAlertEmail());
        taskConfiguration.setNotificationCondition(taskXO.getNotificationCondition());
        taskXO.getProperties().forEach((arg_0, arg_1) -> ((TaskConfiguration)taskConfiguration).setString(arg_0, arg_1));
        Schedule schedule = this.scheduleHelper.asSchedule(taskXO.getFrequency());
        this.taskScheduler.scheduleTask(taskConfiguration, schedule);
    }

    @Override
    @POST
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:tasks:create"})
    @Validate(groups={Create.class, Default.class})
    @Timed
    public Response createTask(@NotNull @Valid TaskTemplateXO taskTemplateXO) {
        this.taskTemplateValidator.checkValid(taskTemplateXO);
        Schedule schedule = this.scheduleHelper.asSchedule(taskTemplateXO.getFrequency());
        TaskConfiguration taskConfiguration = this.taskScheduler.createTaskConfigurationInstance(taskTemplateXO.getType());
        if (!taskConfiguration.isExposed()) {
            throw new ValidationErrorsException("This task is not allowed to be created");
        }
        taskTemplateXO.getProperties().forEach((arg_0, arg_1) -> ((TaskConfiguration)taskConfiguration).setString(arg_0, arg_1));
        taskConfiguration.setAlertEmail(taskTemplateXO.getAlertEmail());
        taskConfiguration.setNotificationCondition(taskTemplateXO.getNotificationCondition());
        taskConfiguration.setName(taskTemplateXO.getName());
        taskConfiguration.setEnabled(taskTemplateXO.getEnabled().booleanValue());
        TaskInfo task = this.taskScheduler.scheduleTask(taskConfiguration, schedule);
        return Response.status((Response.Status)Response.Status.CREATED).entity(new AbstractMap.SimpleEntry<String, String>("id", task.getId())).type("application/json").build();
    }
}

