/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.api.ext.tasks;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sonatype.nexus.api.ext.tasks.FrequencyXO;
import io.swagger.annotations.ApiModelProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import org.sonatype.nexus.scheduling.TaskDescriptor;
import org.sonatype.nexus.scheduling.TaskNotificationCondition;
import org.sonatype.nexus.validation.group.Create;
import org.sonatype.nexus.validation.group.Update;

public class TaskTemplateXO {
    @ApiModelProperty(value="The type of task to be created.", required=true)
    @NotBlank(groups={Create.class})
    @Null(groups={Update.class})
    private final String type;
    @ApiModelProperty(value="The name of the task template.", required=true)
    @NotBlank
    private final String name;
    @ApiModelProperty(value="Indicates if the task would be enabled.", required=true)
    @NotNull
    private final Boolean enabled;
    @ApiModelProperty(value="e-mail for task notifications.")
    @Email
    private final String alertEmail;
    @ApiModelProperty(value="Condition required to notify a task execution.", required=true)
    @NotNull
    private final TaskNotificationCondition notificationCondition;
    @ApiModelProperty(value="Frequency of execution of the task.", required=true)
    @NotNull
    private final FrequencyXO frequency;
    @ApiModelProperty(value="Additional properties for the task")
    private final Map<String, String> properties;

    @JsonCreator
    public TaskTemplateXO(@JsonProperty(value="type") String type, @JsonProperty(value="name") String name, @JsonProperty(value="enabled") Boolean enabled, @JsonProperty(value="alertEmail") String alertEmail, @JsonProperty(value="notificationCondition") TaskNotificationCondition notificationCondition, @JsonProperty(value="frequency") FrequencyXO frequencyXO, @JsonProperty(value="properties") Map<String, String> properties) {
        this.type = type;
        this.name = name;
        this.enabled = enabled;
        this.alertEmail = alertEmail;
        this.notificationCondition = notificationCondition;
        this.frequency = frequencyXO;
        this.properties = properties != null ? properties : Collections.emptyMap();
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public String getAlertEmail() {
        return this.alertEmail;
    }

    public TaskNotificationCondition getNotificationCondition() {
        return this.notificationCondition;
    }

    public FrequencyXO getFrequency() {
        return this.frequency;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public static TaskTemplateXO toTaskTemplateXO(TaskDescriptor info) {
        if (!info.isExposed()) {
            return null;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        if (info.getFormFields() != null) {
            info.getFormFields().forEach(formField -> {
                String initialValue = formField.getInitialValue() == null ? "" : formField.getInitialValue().toString();
                properties.put(formField.getId(), initialValue);
            });
        }
        FrequencyXO frequencyXO = new FrequencyXO();
        frequencyXO.setSchedule("manual");
        return new TaskTemplateXO(info.getId(), info.getName(), true, "admin@example.com", TaskNotificationCondition.DEFAULT, frequencyXO, properties);
    }
}

