/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.api.ext.tasks;

import com.sonatype.nexus.api.ext.tasks.ScheduleEnum;
import com.sonatype.nexus.api.ext.tasks.TaskTemplateXO;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.quartz.CronExpression;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.rest.ValidationErrorsException;
import org.sonatype.nexus.scheduling.TaskDescriptor;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskScheduler;

@Named
@Singleton
public class TaskTemplateValidator {
    private final TaskScheduler taskScheduler;
    private final RepositoryManager repositoryManager;
    private static final String REPOSITORY_PROPERTY = "repositoryName";

    @Inject
    public TaskTemplateValidator(TaskScheduler taskScheduler, RepositoryManager repositoryManager) {
        this.taskScheduler = Objects.requireNonNull(taskScheduler);
        this.repositoryManager = Objects.requireNonNull(repositoryManager);
    }

    public void checkValid(TaskTemplateXO taskTemplate) {
        this.validateType(taskTemplate);
        this.validateFrequency(taskTemplate);
        this.validateProperties(taskTemplate, taskTemplate.getType());
    }

    public void checkValid(TaskTemplateXO taskTemplate, TaskInfo taskInfo) {
        this.validateFrequency(taskTemplate);
        this.validateProperties(taskTemplate, taskInfo.getTypeId());
    }

    private void validateFrequency(TaskTemplateXO taskTemplate) {
        this.validateFrequencySchedule(taskTemplate);
        this.validateFrequencyRecurringDays(taskTemplate);
        this.validateFrequencyCron(taskTemplate);
    }

    private void validateType(TaskTemplateXO taskTemplate) {
        this.getTaskDescriptor(taskTemplate.getType()).orElseThrow(() -> new ValidationErrorsException("Invalid task type"));
    }

    private void validateFrequencySchedule(TaskTemplateXO taskTemplate) {
        try {
            String scheduleString = taskTemplate.getFrequency().getSchedule();
            ScheduleEnum.fromValue(scheduleString);
        }
        catch (IllegalArgumentException ex) {
            throw new ValidationErrorsException(ex.getMessage());
        }
    }

    private void validateFrequencyRecurringDays(TaskTemplateXO taskTemplate) {
        String scheduleString = taskTemplate.getFrequency().getSchedule();
        ScheduleEnum schedule = ScheduleEnum.fromValue(scheduleString);
        Integer[] recurringDays = taskTemplate.getFrequency().getRecurringDays();
        if (schedule.equals((Object)ScheduleEnum.WEEKLY)) {
            Arrays.stream(recurringDays).filter(TaskTemplateValidator.filterDays(1, 7)).findFirst().ifPresent(TaskTemplateValidator.handleInvalidDay());
        } else if (schedule.equals((Object)ScheduleEnum.MONTHLY)) {
            Arrays.stream(recurringDays).filter(TaskTemplateValidator.filterDays(1, 31)).findFirst().ifPresent(TaskTemplateValidator.handleInvalidDay());
        }
    }

    private void validateFrequencyCron(TaskTemplateXO taskTemplate) {
        String scheduleString = taskTemplate.getFrequency().getSchedule();
        ScheduleEnum schedule = ScheduleEnum.fromValue(scheduleString);
        if (schedule.equals((Object)ScheduleEnum.CRON) && !CronExpression.isValidExpression((String)taskTemplate.getFrequency().getCronExpression())) {
            throw new ValidationErrorsException("Invalid cron expression");
        }
    }

    private void validateProperties(TaskTemplateXO taskTemplate, String taskType) {
        TaskDescriptor taskDescriptor = this.getTaskDescriptor(taskType).orElseThrow(() -> new ValidationErrorsException("Invalid task type"));
        this.checkRequiredProperties(taskTemplate, taskDescriptor);
        this.checkInvalidProperties(taskTemplate, taskDescriptor);
    }

    private void checkRequiredProperties(TaskTemplateXO taskTemplate, TaskDescriptor taskDescriptor) {
        taskDescriptor.getFormFields().forEach(formField -> {
            if (formField.isRequired()) {
                String propertyId = formField.getId();
                String propertyValue = taskTemplate.getProperties().get(propertyId);
                if (propertyValue == null || propertyValue.isEmpty()) {
                    String message = String.format("Property '%s' not found", formField.getId());
                    throw new ValidationErrorsException(message);
                }
                if (propertyId.equals(REPOSITORY_PROPERTY)) {
                    this.validateRepositoryExists(propertyValue);
                }
            }
        });
    }

    private void checkInvalidProperties(TaskTemplateXO taskTemplate, TaskDescriptor taskDescriptor) {
        taskTemplate.getProperties().forEach((key, value) -> {
            FormField formField2 = taskDescriptor.getFormFields().stream().filter(formField -> formField.getId().equals(key)).findAny().orElseThrow(() -> {
                String message = String.format("Invalid property '%s'", key);
                return new ValidationErrorsException(message);
            });
        });
    }

    private void validateRepositoryExists(String repoName) {
        Repository repository = this.repositoryManager.get(repoName);
        if (repository == null) {
            String message = String.format("Invalid repository name '%s'", repoName);
            throw new ValidationErrorsException(message);
        }
    }

    private Optional<TaskDescriptor> getTaskDescriptor(String type) {
        return this.taskScheduler.getTaskFactory().getDescriptors().stream().filter(taskDescriptor -> taskDescriptor.getId().equals(type)).findFirst();
    }

    private static Consumer<Integer> handleInvalidDay() {
        return day -> {
            String message = String.format("Invalid recurring day '%d'", day);
            throw new ValidationErrorsException(message);
        };
    }

    private static Predicate<Integer> filterDays(int initial, int end) {
        return day -> day < initial || day > end;
    }
}

