/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.api.ext.tasks;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.api.ext.tasks.FrequencyXO;
import com.sonatype.nexus.api.ext.tasks.utils.TimeZoneUtils;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.sonatype.nexus.rest.ValidationErrorsException;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.schedule.Monthly;
import org.sonatype.nexus.scheduling.schedule.Schedule;
import org.sonatype.nexus.scheduling.schedule.Weekly;

@Named
@Singleton
public class ScheduleHelper {
    private final TaskScheduler taskScheduler;

    @Inject
    public ScheduleHelper(TaskScheduler taskScheduler) {
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
    }

    public Schedule asSchedule(FrequencyXO frequencyXO) {
        block21: {
            ZoneOffset clientZoneOffset = StringUtils.isBlank((String)frequencyXO.getTimeZoneOffset()) ? ZoneOffset.UTC : ZoneOffset.of(frequencyXO.getTimeZoneOffset());
            if ("cron".equals(frequencyXO.getSchedule())) {
                return this.taskScheduler.getScheduleFactory().cron(new Date(), frequencyXO.getCronExpression(), clientZoneOffset.getId());
            }
            if ("manual".equals(frequencyXO.getSchedule())) break block21;
            if (frequencyXO.getStartDate() == null) {
                throw new RuntimeException("startDate is null");
            }
            Instant startDateUTC = Instant.ofEpochMilli(frequencyXO.getStartDate());
            LocalDateTime startDateClient = LocalDateTime.ofInstant(startDateUTC, ZoneId.of(clientZoneOffset.getId()));
            LocalDateTime startDateServer = LocalDateTime.ofInstant(startDateUTC, ZoneId.systemDefault());
            Calendar date = Calendar.getInstance();
            date.setTimeInMillis(frequencyXO.getStartDate());
            date.set(13, 0);
            date.set(14, 0);
            switch (frequencyXO.getSchedule()) {
                case "once": {
                    return this.taskScheduler.getScheduleFactory().once(date.getTime());
                }
                case "hourly": {
                    return this.taskScheduler.getScheduleFactory().hourly(date.getTime());
                }
                case "daily": {
                    return this.taskScheduler.getScheduleFactory().daily(date.getTime());
                }
                case "weekly": {
                    return this.taskScheduler.getScheduleFactory().weekly(date.getTime(), Arrays.stream(frequencyXO.getRecurringDays()).map(recurringDay -> Weekly.Weekday.values()[TimeZoneUtils.shiftWeekDay(recurringDay - 1, startDateClient, startDateServer)]).collect(Collectors.toSet()));
                }
                case "monthly": {
                    return this.taskScheduler.getScheduleFactory().monthly(date.getTime(), Arrays.stream(frequencyXO.getRecurringDays()).map(recurringDay -> recurringDay == 999 ? Monthly.CalendarDay.lastDay() : Monthly.CalendarDay.day((int)TimeZoneUtils.shiftMonthDay(recurringDay, startDateClient, startDateServer))).collect(Collectors.toSet()));
                }
            }
            throw new ValidationErrorsException("Unknown schedule: " + frequencyXO.getSchedule());
        }
        return this.taskScheduler.getScheduleFactory().manual();
    }
}

