/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.api.ext.iq;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.sonatype.nexus.api.ext.iq.IqAuditXo;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.core.Response;
import org.sonatype.nexus.capability.CapabilityReference;
import org.sonatype.nexus.capability.CapabilityReferenceFilterBuilder;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.capability.CapabilityType;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.types.ProxyType;
import org.sonatype.nexus.rest.ValidationErrorsException;
import org.sonatype.nexus.rest.WebApplicationMessageException;

@Named
@Singleton
public class IqApiResourceProService {
    private static final CapabilityType FIREWALL_AUDIT_CAPABILITY_TYPE = new CapabilityType("firewall.audit");
    private final RepositoryManager repositoryManager;
    private final CapabilityRegistry capabilityRegistry;

    @Inject
    public IqApiResourceProService(RepositoryManager repositoryManager, CapabilityRegistry capabilityRegistry) {
        this.repositoryManager = Objects.requireNonNull(repositoryManager);
        this.capabilityRegistry = Objects.requireNonNull(capabilityRegistry);
    }

    public IqAuditXo get(String repositoryName) {
        this.repositoryExistsValidator(repositoryName);
        this.repositoryProxyTypeValidator(repositoryName);
        IqAuditXo iqAuditXo = new IqAuditXo(repositoryName, false, false);
        CapabilityReference repositoryCapabilityReference = this.capabilityRegistry.getAll().stream().filter(reference -> reference.context().type().toString().equals(FIREWALL_AUDIT_CAPABILITY_TYPE.toString())).filter(capabilityReference -> ((String)capabilityReference.context().properties().get("repository")).equals(repositoryName)).findFirst().orElse(null);
        if (repositoryCapabilityReference == null) {
            return iqAuditXo;
        }
        iqAuditXo.setEnabled(repositoryCapabilityReference.context().isEnabled());
        iqAuditXo.setEnabledQuarantine(Boolean.parseBoolean((String)repositoryCapabilityReference.context().properties().get("quarantine")));
        return iqAuditXo;
    }

    public List<IqAuditXo> getAll() {
        Map<String, CapabilityReference> capabilityReferenceMap = this.capabilityRegistry.getAll().stream().filter(reference -> reference.context().type().toString().equals(FIREWALL_AUDIT_CAPABILITY_TYPE.toString())).collect(Collectors.toMap(capabilityReference -> (String)capabilityReference.context().properties().get("repository"), capabilityReference -> capabilityReference));
        return StreamSupport.stream(this.repositoryManager.browse().spliterator(), false).filter(repository -> repository.getType().getValue().equals("proxy")).map(repository -> {
            IqAuditXo auditXo = new IqAuditXo(repository.getName(), false, false);
            if (capabilityReferenceMap.containsKey(repository.getName())) {
                CapabilityReference reference = (CapabilityReference)capabilityReferenceMap.get(repository.getName());
                auditXo.setEnabled(reference.context().isEnabled());
                auditXo.setEnabledQuarantine(Boolean.parseBoolean((String)reference.context().properties().get("quarantine")));
            }
            return auditXo;
        }).collect(Collectors.toList());
    }

    public CapabilityReference manageAudit(IqAuditXo iqAuditXo) {
        String repositoryName = iqAuditXo.getRepositoryName();
        this.repositoryExistsValidator(repositoryName);
        this.repositoryProxyTypeValidator(repositoryName);
        CapabilityReference firewallAuditCapability = this.getFirewallAuditCapability(repositoryName);
        if (firewallAuditCapability == null) {
            return this.createFirewallAuditCapability(iqAuditXo);
        }
        return this.updateFirewallAuditCapability(firewallAuditCapability, iqAuditXo);
    }

    private CapabilityReference createFirewallAuditCapability(IqAuditXo iqAuditXo) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("repository", iqAuditXo.getRepositoryName());
        properties.put("quarantine", String.valueOf(iqAuditXo.getEnabledQuarantine()));
        boolean enabledCapability = Boolean.TRUE.equals(iqAuditXo.getEnabled());
        return this.capabilityRegistry.add(FIREWALL_AUDIT_CAPABILITY_TYPE, enabledCapability, null, properties);
    }

    private CapabilityReference updateFirewallAuditCapability(CapabilityReference firewallAuditCapability, IqAuditXo iqAuditXo) {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>(firewallAuditCapability.context().properties());
        properties.put("quarantine", String.valueOf(iqAuditXo.getEnabledQuarantine()));
        Boolean iqAuditXoEnabled = iqAuditXo.getEnabled();
        boolean enabledCapabilityCurrent = firewallAuditCapability.context().isEnabled();
        boolean enabledCapability = iqAuditXoEnabled == null ? enabledCapabilityCurrent : iqAuditXoEnabled;
        return this.capabilityRegistry.update(firewallAuditCapability.context().id(), enabledCapability, firewallAuditCapability.context().notes(), properties);
    }

    @Nullable
    private CapabilityReference getFirewallAuditCapability(String repositoryName) {
        return this.capabilityRegistry.get((Predicate)CapabilityReferenceFilterBuilder.capabilities().withType(FIREWALL_AUDIT_CAPABILITY_TYPE).withProperty("repository", repositoryName)).stream().findFirst().orElse(null);
    }

    @VisibleForTesting
    void repositoryExistsValidator(String repositoryName) {
        if (!this.repositoryManager.exists(repositoryName)) {
            throw new WebApplicationMessageException(Response.Status.NOT_FOUND, (Object)String.format("No repository has found '%s'", repositoryName), "application/json");
        }
    }

    @VisibleForTesting
    void repositoryProxyTypeValidator(String repositoryName) {
        Repository repository = this.repositoryManager.get(repositoryName);
        Objects.requireNonNull(repository);
        Type type = repository.getType();
        if (!(type instanceof ProxyType)) {
            throw new ValidationErrorsException("type", String.format("Repository type must be '%s'. Actual '%s'", "proxy", type.getValue()));
        }
    }
}

