/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.api.ext.iq;

import com.codahale.metrics.annotation.Timed;
import com.sonatype.nexus.api.ext.iq.IqApiResourceProService;
import com.sonatype.nexus.api.ext.iq.IqAuditXo;
import com.sonatype.nexus.api.ext.iq.doc.IqApiResourceDocPro;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.nexus.rest.Resource;

@Named
@Singleton
@Path(value="/v1/iq/audit")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class IqApiResourcePro
implements Resource,
IqApiResourceDocPro {
    public static final String RESOURCE_URI = "/v1/iq/audit";
    private final IqApiResourceProService iqApiResourceProService;

    @Inject
    public IqApiResourcePro(IqApiResourceProService iqApiResourceProService) {
        this.iqApiResourceProService = Objects.requireNonNull(iqApiResourceProService);
    }

    @Override
    @PUT
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:settings:update"})
    @Timed
    public Response manageAudit(@Valid IqAuditXo iqAuditXo) {
        this.iqApiResourceProService.manageAudit(iqAuditXo);
        return Response.noContent().build();
    }

    @Override
    @GET
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:settings:read"})
    @Timed
    public List<IqAuditXo> getAllAuditStatus() {
        return this.iqApiResourceProService.getAll();
    }

    @Override
    @GET
    @Path(value="{repositoryName}")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:settings:read"})
    @Timed
    public Response getAuditStatus(@PathParam(value="repositoryName") String repositoryName) {
        IqAuditXo iqAuditXo = this.iqApiResourceProService.get(repositoryName);
        return Response.status((int)200).entity((Object)iqAuditXo).build();
    }
}

