/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.api.ext.http;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.api.ext.http.AuthSettingsXo;
import com.sonatype.nexus.api.ext.http.HttpSettingsXo;
import com.sonatype.nexus.api.ext.http.ProxySettingsXo;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.httpclient.HttpClientManager;
import org.sonatype.nexus.httpclient.HttpDefaultsCustomizer;
import org.sonatype.nexus.httpclient.config.AuthenticationConfiguration;
import org.sonatype.nexus.httpclient.config.ConnectionConfiguration;
import org.sonatype.nexus.httpclient.config.HttpClientConfiguration;
import org.sonatype.nexus.httpclient.config.NtlmAuthenticationConfiguration;
import org.sonatype.nexus.httpclient.config.ProxyConfiguration;
import org.sonatype.nexus.httpclient.config.ProxyServerConfiguration;
import org.sonatype.nexus.httpclient.config.UsernameAuthenticationConfiguration;

@Named
@Singleton
public class HttpSettingsApiResourceProService {
    private final HttpClientManager httpClientManager;
    final HttpDefaultsCustomizer httpDefaultsCustomizer;

    @Inject
    public HttpSettingsApiResourceProService(HttpClientManager httpClientManager, HttpDefaultsCustomizer httpDefaultsCustomizer) {
        this.httpClientManager = (HttpClientManager)Preconditions.checkNotNull((Object)httpClientManager);
        this.httpDefaultsCustomizer = (HttpDefaultsCustomizer)Preconditions.checkNotNull((Object)httpDefaultsCustomizer);
    }

    public HttpSettingsXo getHttpSettings() {
        HttpClientConfiguration httpClientConfiguration = this.httpClientManager.getConfiguration();
        return this.convert(httpClientConfiguration);
    }

    public void reset() {
        HttpClientConfiguration defaultHttpClientConfig = this.httpClientManager.newConfiguration();
        this.httpClientManager.setConfiguration(defaultHttpClientConfig);
    }

    private HttpSettingsXo convert(HttpClientConfiguration clientConfiguration) {
        ProxyConfiguration proxyConfiguration;
        HttpSettingsXo httpSettingsXo = new HttpSettingsXo();
        httpSettingsXo.setRetries(this.httpDefaultsCustomizer.getRetryCount());
        httpSettingsXo.setTimeout(this.httpDefaultsCustomizer.getRequestTimeout().toSecondsI());
        ConnectionConfiguration connectionConfiguration = clientConfiguration.getConnection();
        if (connectionConfiguration != null) {
            httpSettingsXo.setUserAgent(connectionConfiguration.getUserAgentSuffix());
            httpSettingsXo.setTimeout(connectionConfiguration.getTimeout() != null ? connectionConfiguration.getTimeout().toSecondsI() : this.httpDefaultsCustomizer.getRequestTimeout().toSecondsI());
            httpSettingsXo.setRetries(connectionConfiguration.getRetries() != null ? connectionConfiguration.getRetries().intValue() : this.httpDefaultsCustomizer.getRetryCount());
        }
        if ((proxyConfiguration = clientConfiguration.getProxy()) != null) {
            String[] nonProxyHosts;
            ProxyServerConfiguration https;
            ProxyServerConfiguration http = proxyConfiguration.getHttp();
            if (http != null) {
                ProxySettingsXo proxySettingsXo = this.copyProxySettings(http);
                httpSettingsXo.setHttpProxy(proxySettingsXo);
            }
            if ((https = proxyConfiguration.getHttps()) != null) {
                ProxySettingsXo proxySettingsXo = this.copyProxySettings(https);
                httpSettingsXo.setHttpsProxy(proxySettingsXo);
            }
            if ((nonProxyHosts = proxyConfiguration.getNonProxyHosts()) != null) {
                httpSettingsXo.setNonProxyHosts(new HashSet<String>(Arrays.asList(nonProxyHosts)));
            }
        }
        return httpSettingsXo;
    }

    public void update(HttpSettingsXo newSettings) {
        HttpClientConfiguration newConfiguration = this.convert(newSettings);
        this.httpClientManager.setConfiguration(newConfiguration);
    }

    private ProxySettingsXo copyProxySettings(ProxyServerConfiguration proxyServerConfiguration) {
        ProxySettingsXo proxySettingsXo = new ProxySettingsXo();
        proxySettingsXo.setEnabled(proxyServerConfiguration.isEnabled());
        proxySettingsXo.setHost(proxyServerConfiguration.getHost());
        proxySettingsXo.setPort(String.valueOf(proxyServerConfiguration.getPort()));
        AuthenticationConfiguration authConfig = proxyServerConfiguration.getAuthentication();
        if (authConfig != null) {
            AuthSettingsXo authSettingsXo = this.configureAuthSettings(authConfig);
            proxySettingsXo.setAuthInfo(authSettingsXo);
        }
        return proxySettingsXo;
    }

    private AuthSettingsXo configureAuthSettings(AuthenticationConfiguration authenticationConfiguration) {
        AuthSettingsXo authSettingsXo = new AuthSettingsXo();
        authSettingsXo.setEnabled(Boolean.TRUE);
        if (authenticationConfiguration instanceof UsernameAuthenticationConfiguration) {
            authSettingsXo.setUsername(((UsernameAuthenticationConfiguration)authenticationConfiguration).getUsername());
            authSettingsXo.setPassword(((UsernameAuthenticationConfiguration)authenticationConfiguration).getPassword());
        } else if (authenticationConfiguration instanceof NtlmAuthenticationConfiguration) {
            authSettingsXo.setUsername(((NtlmAuthenticationConfiguration)authenticationConfiguration).getUsername());
            authSettingsXo.setPassword(((NtlmAuthenticationConfiguration)authenticationConfiguration).getPassword());
            authSettingsXo.setNtlmDomain(((NtlmAuthenticationConfiguration)authenticationConfiguration).getDomain());
            authSettingsXo.setNtlmHost(((NtlmAuthenticationConfiguration)authenticationConfiguration).getHost());
        }
        return authSettingsXo;
    }

    private HttpClientConfiguration convert(HttpSettingsXo xo) {
        ProxyServerConfiguration proxyServerConfiguration;
        HttpClientConfiguration configuration = this.httpClientManager.newConfiguration();
        ConnectionConfiguration connectionConfiguration = new ConnectionConfiguration();
        if (!Strings2.isBlank((String)xo.getUserAgent())) {
            connectionConfiguration.setUserAgentSuffix(xo.getUserAgent());
        }
        if (Objects.nonNull(xo.getTimeout())) {
            connectionConfiguration.setTimeout(Time.seconds((long)xo.getTimeout().intValue()));
        }
        if (Objects.nonNull(xo.getRetries())) {
            connectionConfiguration.setRetries(xo.getRetries());
        }
        configuration.setConnection(connectionConfiguration);
        ProxyConfiguration proxyConfiguration = new ProxyConfiguration();
        if (Objects.nonNull(xo.getNonProxyHosts())) {
            proxyConfiguration.setNonProxyHosts(xo.getNonProxyHosts().toArray(new String[0]));
        }
        if (Objects.nonNull(xo.getHttpProxy()) && xo.getHttpProxy().getEnabled().booleanValue()) {
            proxyServerConfiguration = this.createProxyServerConfiguration(xo.getHttpProxy());
            proxyConfiguration.setHttp(proxyServerConfiguration);
        }
        if (Objects.nonNull(xo.getHttpsProxy()) && xo.getHttpsProxy().getEnabled().booleanValue()) {
            proxyServerConfiguration = this.createProxyServerConfiguration(xo.getHttpsProxy());
            proxyConfiguration.setHttps(proxyServerConfiguration);
        }
        configuration.setProxy(proxyConfiguration);
        return configuration;
    }

    private ProxyServerConfiguration createProxyServerConfiguration(ProxySettingsXo proxySettingsXo) {
        ProxyServerConfiguration proxyServerConfiguration = new ProxyServerConfiguration();
        proxyServerConfiguration.setEnabled(proxySettingsXo.getEnabled().booleanValue());
        proxyServerConfiguration.setHost(proxySettingsXo.getHost());
        if (proxySettingsXo.getAuthInfo().getEnabled().booleanValue()) {
            proxyServerConfiguration.setAuthentication(this.createAuthenticationConfiguration(proxySettingsXo.getAuthInfo()));
        }
        return proxyServerConfiguration;
    }

    private AuthenticationConfiguration createAuthenticationConfiguration(AuthSettingsXo authSettingsXo) {
        UsernameAuthenticationConfiguration authenticationConfiguration;
        if (Strings2.isBlank((String)authSettingsXo.getNtlmDomain()) && Strings2.isBlank((String)authSettingsXo.getNtlmHost())) {
            UsernameAuthenticationConfiguration usernameConfig = new UsernameAuthenticationConfiguration();
            usernameConfig.setUsername(authSettingsXo.getUsername());
            usernameConfig.setPassword(authSettingsXo.getPassword());
            authenticationConfiguration = usernameConfig;
        } else {
            NtlmAuthenticationConfiguration ntlmConfig = new NtlmAuthenticationConfiguration();
            ntlmConfig.setUsername(authSettingsXo.getUsername());
            ntlmConfig.setPassword(authSettingsXo.getPassword());
            ntlmConfig.setDomain(authSettingsXo.getNtlmDomain());
            ntlmConfig.setHost(authSettingsXo.getNtlmHost());
            authenticationConfiguration = ntlmConfig;
        }
        return authenticationConfiguration;
    }
}

