/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.api.ext.http;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.api.ext.http.HttpSettingsApiResourceProService;
import com.sonatype.nexus.api.ext.http.HttpSettingsXo;
import com.sonatype.nexus.api.ext.http.doc.HttpSettingsApiResourceDocPro;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.rest.Resource;

@FeatureFlag(name="nexus.api.extended.enabled")
@Named
@Singleton
@Path(value="/v1/http")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class HttpSettingsApiResourcePro
implements Resource,
HttpSettingsApiResourceDocPro {
    public static final String RESOURCE_URI = "/v1/http";
    private final HttpSettingsApiResourceProService httpSettingsApiResourceProService;

    @Inject
    public HttpSettingsApiResourcePro(HttpSettingsApiResourceProService httpSettingsApiResourceProService) {
        this.httpSettingsApiResourceProService = (HttpSettingsApiResourceProService)Preconditions.checkNotNull((Object)httpSettingsApiResourceProService);
    }

    @Override
    @GET
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:settings:read"})
    @Timed
    public Response getHttpSettings() {
        HttpSettingsXo httpSettingsXo = this.httpSettingsApiResourceProService.getHttpSettings();
        return Response.status((int)200).entity((Object)httpSettingsXo).build();
    }

    @Override
    @PUT
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:settings:update"})
    @Timed
    public void updateHttpSettings(@NotNull @Valid HttpSettingsXo httpSettingsXo) {
        this.httpSettingsApiResourceProService.update(httpSettingsXo);
    }

    @Override
    @DELETE
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:settings:update"})
    @Timed
    public Response resetHttpSettings() {
        this.httpSettingsApiResourceProService.reset();
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }
}

