/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.api.ext.cleanup;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.sonatype.nexus.cleanup.storage.config.CleanupPolicyAssetNamePattern;

public class CleanupPolicyResourceXO {
    @Pattern(regexp="^[a-zA-Z0-9\\-]{1}[a-zA-Z0-9_\\-\\.]*$", message="{org.sonatype.nexus.validation.constraint.name}")
    @NotEmpty
    @Size(max=255)
    private @Pattern(regexp="^[a-zA-Z0-9\\-]{1}[a-zA-Z0-9_\\-\\.]*$", message="{org.sonatype.nexus.validation.constraint.name}") @NotEmpty @Size(max=255) String name;
    @NotEmpty
    private String format;
    private String notes;
    private Long criteriaLastBlobUpdated;
    private Long criteriaLastDownloaded;
    private CriteriaReleaseTypeEnum criteriaReleaseType;
    @CleanupPolicyAssetNamePattern
    private String criteriaAssetRegex;
    @Min(value=1L, message="retain must be > 0")
    private @Min(value=1L, message="retain must be > 0") Integer retain;

    @ApiModelProperty(required=true, value="policy name")
    @JsonProperty(value="name")
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(required=true, value="repository format")
    @JsonProperty(value="format")
    @NotNull
    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @ApiModelProperty(value="description")
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    @ApiModelProperty(value="component age (Components published over \u201cx\u201d days ago (e.g 1-999))")
    public Long getCriteriaLastBlobUpdated() {
        return this.criteriaLastBlobUpdated;
    }

    public void setCriteriaLastBlobUpdated(Long criteriaLastBlobUpdated) {
        this.criteriaLastBlobUpdated = criteriaLastBlobUpdated;
    }

    @ApiModelProperty(value="component usage (Components downloaded in \u201cx\u201d amount of days (e.g 1-999))")
    public Long getCriteriaLastDownloaded() {
        return this.criteriaLastDownloaded;
    }

    public void setCriteriaLastDownloaded(Long criteriaLastDownloaded) {
        this.criteriaLastDownloaded = criteriaLastDownloaded;
    }

    @ApiModelProperty(value="release type (Remove components that are of the following release type:)")
    public CriteriaReleaseTypeEnum getCriteriaReleaseType() {
        return this.criteriaReleaseType;
    }

    public void setCriteriaReleaseType(CriteriaReleaseTypeEnum criteriaReleaseType) {
        this.criteriaReleaseType = criteriaReleaseType;
    }

    @ApiModelProperty(value="asset name matcher (Remove components that have at least one asset name matching the following regular expression pattern:)")
    public String getCriteriaAssetRegex() {
        return this.criteriaAssetRegex;
    }

    public void setCriteriaAssetRegex(String criteriaAssetRegex) {
        this.criteriaAssetRegex = criteriaAssetRegex;
    }

    @ApiModelProperty(value="keep the latest \"x\" number of versions")
    @Min(value=1L)
    public @Min(value=1L) Integer getRetain() {
        return this.retain;
    }

    public void setRetain(Integer retain) {
        this.retain = retain;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CleanupPolicyResourceXO that = (CleanupPolicyResourceXO)object;
        return Objects.equals(this.name, that.name) && Objects.equals(this.format, that.format) && Objects.equals(this.notes, that.notes) && Objects.equals(this.criteriaLastBlobUpdated, that.criteriaLastBlobUpdated) && Objects.equals(this.criteriaLastDownloaded, that.criteriaLastDownloaded) && this.criteriaReleaseType == that.criteriaReleaseType && Objects.equals(this.criteriaAssetRegex, that.criteriaAssetRegex) && Objects.equals(this.retain, that.retain);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.format, this.notes, this.criteriaLastBlobUpdated, this.criteriaLastDownloaded, this.criteriaReleaseType, this.criteriaAssetRegex, this.retain});
    }

    public static enum CriteriaReleaseTypeEnum {
        RELEASES("RELEASES"),
        PRERELEASES("PRERELEASES"),
        RELEASES_AND_PRERELEASES("RELEASES_AND_PRERELEASES");

        private String value;

        private CriteriaReleaseTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

