/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.api.ext.cleanup;

import com.sonatype.nexus.api.ext.cleanup.CleanupPolicyResourceXO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.cleanup.config.CleanupPolicyConfiguration;
import org.sonatype.nexus.cleanup.storage.CleanupPolicy;
import org.sonatype.nexus.cleanup.storage.CleanupPolicyStorage;
import org.sonatype.nexus.cleanup.storage.SortType;
import org.sonatype.nexus.common.db.DatabaseCheck;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.rest.ValidationErrorsException;

@Named
@Singleton
public class CleanupPolicyResourceHelper {
    public static final String MODE_DELETE = "delete";
    private final List<Format> formats;
    private final CleanupPolicyStorage cleanupPolicyStorage;
    private final Map<String, CleanupPolicyConfiguration> cleanupFormatConfigurationMap;
    private final CleanupPolicyConfiguration defaultCleanupFormatConfiguration;
    private final RepositoryManager repositoryManager;
    private final DatabaseCheck databaseCheck;
    private final Map<String, SortType> formatToSortCriteria = new HashMap<String, SortType>();

    @Inject
    public CleanupPolicyResourceHelper(List<Format> formats, CleanupPolicyStorage cleanupPolicyStorage, Map<String, CleanupPolicyConfiguration> cleanupFormatConfigurationMap, CleanupPolicyConfiguration defaultCleanupFormatConfiguration, RepositoryManager repositoryManager, DatabaseCheck databaseCheck) {
        this.formats = formats;
        this.cleanupPolicyStorage = Objects.requireNonNull(cleanupPolicyStorage);
        this.cleanupFormatConfigurationMap = Objects.requireNonNull(cleanupFormatConfigurationMap);
        this.defaultCleanupFormatConfiguration = Objects.requireNonNull(defaultCleanupFormatConfiguration);
        this.repositoryManager = Objects.requireNonNull(repositoryManager);
        this.databaseCheck = Objects.requireNonNull(databaseCheck);
        this.formatToSortCriteria.put("docker", SortType.DATE);
        this.formatToSortCriteria.put("maven2", SortType.VERSION);
    }

    public void formatExistsValidator(CleanupPolicyResourceXO cleanupPolicyXO) {
        String formatName = cleanupPolicyXO.getFormat();
        boolean match = this.formats.stream().anyMatch(it -> it.getValue().equals(formatName));
        if (!match) {
            throw new ValidationErrorsException("format", "specified format " + formatName + " is not valid.");
        }
    }

    public void atLeastOneCriteriaHasSelected(CleanupPolicyResourceXO cleanupPolicyXO) {
        String criteriaAssetRegex = cleanupPolicyXO.getCriteriaAssetRegex();
        Long criteriaLastBlobUpdated = cleanupPolicyXO.getCriteriaLastBlobUpdated();
        Long criteriaLastDownloaded = cleanupPolicyXO.getCriteriaLastDownloaded();
        if (StringUtils.isNotBlank((CharSequence)criteriaAssetRegex) || criteriaLastBlobUpdated != null && criteriaLastBlobUpdated > 0L || criteriaLastDownloaded != null && criteriaLastDownloaded > 0L) {
            return;
        }
        throw new ValidationErrorsException("criterion", "At least one criterion(criteriaAssetRegex, criteriaLastBlobUpdated, criteriaLastDownloaded)  must be selected");
    }

    public void validateFormatNotChangedIfInUse(CleanupPolicyResourceXO cleanupPolicyXO, CleanupPolicy cleanupPolicy) {
        int inUseCount = (int)this.repositoryManager.browseForCleanupPolicy(cleanupPolicyXO.getName()).count();
        if (!cleanupPolicyXO.getFormat().equals("*") && !cleanupPolicy.getFormat().equals(cleanupPolicyXO.getFormat()) && inUseCount > 0) {
            throw new ValidationErrorsException("format", "You cannot change the format of a policy that is in use.");
        }
    }

    public void validateRetainAttributes(CleanupPolicyResourceXO cleanupPolicyResourceXO) {
        if (cleanupPolicyResourceXO.getRetain() != null) {
            if (!this.databaseCheck.isPostgresql()) {
                throw new ValidationErrorsException("The current data source is not supported by the exclusion criteria.");
            }
            if (!this.isRetainSupportedByFormat(cleanupPolicyResourceXO)) {
                throw new ValidationErrorsException("The specified format is not supported by the exclusion criteria.");
            }
        }
    }

    private boolean isRetainSupportedByFormat(CleanupPolicyResourceXO cleanupPolicyResourceXO) {
        String format = cleanupPolicyResourceXO.getFormat();
        CleanupPolicyResourceXO.CriteriaReleaseTypeEnum releaseType = cleanupPolicyResourceXO.getCriteriaReleaseType();
        return format.equals("docker") || format.equals("maven2") && releaseType == CleanupPolicyResourceXO.CriteriaReleaseTypeEnum.RELEASES;
    }

    public CleanupPolicyResourceXO fromCleanupPolicy(CleanupPolicy cleanupPolicy) {
        CleanupPolicyResourceXO xo = new CleanupPolicyResourceXO();
        xo.setName(cleanupPolicy.getName());
        xo.setFormat(cleanupPolicy.getFormat().equals("ALL_FORMATS") ? "*" : cleanupPolicy.getFormat());
        xo.setNotes(cleanupPolicy.getNotes());
        xo.setCriteriaAssetRegex((String)cleanupPolicy.getCriteria().get("regex"));
        xo.setCriteriaLastBlobUpdated(CleanupPolicyResourceHelper.toDays(CleanupPolicyResourceHelper.getNullableLong(cleanupPolicy.getCriteria(), "lastBlobUpdated")));
        xo.setCriteriaLastDownloaded(CleanupPolicyResourceHelper.toDays(CleanupPolicyResourceHelper.getNullableLong(cleanupPolicy.getCriteria(), "lastDownloaded")));
        xo.setRetain(CleanupPolicyResourceHelper.getNullableInt(cleanupPolicy.getCriteria(), "retain"));
        xo.setCriteriaReleaseType(CleanupPolicyResourceHelper.getNullableReleaseType(cleanupPolicy.getCriteria()));
        return xo;
    }

    public CleanupPolicy toCleanupPolicy(CleanupPolicyResourceXO cleanupPolicyXO) {
        CleanupPolicy policy = this.cleanupPolicyStorage.newCleanupPolicy();
        policy.setName(cleanupPolicyXO.getName());
        policy.setNotes(cleanupPolicyXO.getNotes());
        policy.setMode(MODE_DELETE);
        policy.setFormat(cleanupPolicyXO.getFormat());
        policy.setCriteria(this.toCriteriaMap(cleanupPolicyXO));
        return policy;
    }

    public Map<String, String> toCriteriaMap(CleanupPolicyResourceXO cleanupPolicyXO) {
        HashMap<String, String> criteriaMap = new HashMap<String, String>();
        CleanupPolicyConfiguration cleanupFormatConfiguration = this.cleanupFormatConfigurationMap.get(cleanupPolicyXO.getFormat());
        if (cleanupFormatConfiguration == null) {
            cleanupFormatConfiguration = this.defaultCleanupFormatConfiguration;
        }
        this.handleCriteria(cleanupFormatConfiguration, criteriaMap, "regex", cleanupPolicyXO.getCriteriaAssetRegex(), "Asset name regex", cleanupPolicyXO.getFormat());
        this.handleCriteria(cleanupFormatConfiguration, criteriaMap, "lastBlobUpdated", CleanupPolicyResourceHelper.toSeconds(cleanupPolicyXO.getCriteriaLastBlobUpdated()), "Published before", cleanupPolicyXO.getFormat());
        this.handleCriteria(cleanupFormatConfiguration, criteriaMap, "lastDownloaded", CleanupPolicyResourceHelper.toSeconds(cleanupPolicyXO.getCriteriaLastDownloaded()), "Last downloaded before", cleanupPolicyXO.getFormat());
        if (CleanupPolicyResourceXO.CriteriaReleaseTypeEnum.RELEASES_AND_PRERELEASES.equals((Object)cleanupPolicyXO.getCriteriaReleaseType())) {
            this.handleCriteria(cleanupFormatConfiguration, criteriaMap, "isPrerelease", (Object)cleanupPolicyXO.getCriteriaReleaseType(), "Release type", cleanupPolicyXO.getFormat());
        } else if (cleanupPolicyXO.getCriteriaReleaseType() != null) {
            this.handleCriteria(cleanupFormatConfiguration, criteriaMap, "isPrerelease", CleanupPolicyResourceXO.CriteriaReleaseTypeEnum.PRERELEASES.equals((Object)cleanupPolicyXO.getCriteriaReleaseType()), "Release type", cleanupPolicyXO.getFormat());
        }
        if (cleanupPolicyXO.getRetain() != null) {
            this.handleCriteria(cleanupFormatConfiguration, criteriaMap, "retain", cleanupPolicyXO.getRetain(), "Retain components", cleanupPolicyXO.getFormat());
            SortType sortBy = this.formatToSortCriteria.get(cleanupPolicyXO.getFormat());
            this.handleCriteria(cleanupFormatConfiguration, criteriaMap, "sortBy", sortBy.value, "Retain sort by", cleanupPolicyXO.getFormat());
        }
        return criteriaMap;
    }

    private void handleCriteria(CleanupPolicyConfiguration cleanupPolicyConfiguration, Map<String, String> criteriaMap, String key, Object value, String keyText, String format) {
        if (value != null) {
            Boolean val = (Boolean)cleanupPolicyConfiguration.getConfiguration().get(key);
            if (Boolean.TRUE.equals(val)) {
                if (CleanupPolicyResourceXO.CriteriaReleaseTypeEnum.RELEASES_AND_PRERELEASES.equals(value)) {
                    criteriaMap.put(key, null);
                } else {
                    criteriaMap.put(key, String.valueOf(value));
                }
            } else {
                throw new ValidationErrorsException(String.format("Specified format %s does not support the '%s' criteria.", format, keyText));
            }
        }
    }

    private static Long toSeconds(Long days) {
        if (days == null) {
            return null;
        }
        return TimeUnit.DAYS.toSeconds(days);
    }

    private static Long toDays(Long seconds) {
        if (seconds == null) {
            return null;
        }
        return TimeUnit.SECONDS.toDays(seconds);
    }

    private static Long getNullableLong(Map<String, String> map, String key) {
        String value = map.get(key);
        if (value == null) {
            return null;
        }
        return Long.valueOf(value);
    }

    private static Integer getNullableInt(Map<String, String> map, String key) {
        String value = map.get(key);
        if (value == null) {
            return null;
        }
        return Integer.valueOf(value);
    }

    private static CleanupPolicyResourceXO.CriteriaReleaseTypeEnum getNullableReleaseType(Map<String, String> map) {
        String value = map.get("isPrerelease");
        if (value == null) {
            if (map.containsKey("isPrerelease")) {
                return CleanupPolicyResourceXO.CriteriaReleaseTypeEnum.RELEASES_AND_PRERELEASES;
            }
            return null;
        }
        return Boolean.parseBoolean(value) ? CleanupPolicyResourceXO.CriteriaReleaseTypeEnum.PRERELEASES : CleanupPolicyResourceXO.CriteriaReleaseTypeEnum.RELEASES;
    }
}

