/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.api.ext.cleanup;

import com.codahale.metrics.annotation.Timed;
import com.sonatype.nexus.api.ext.cleanup.CleanupPolicyResourceHelper;
import com.sonatype.nexus.api.ext.cleanup.CleanupPolicyResourceXO;
import com.sonatype.nexus.api.ext.cleanup.doc.CleanupApiResourceDocPro;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.groups.Default;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.cleanup.content.CleanupPolicyCreatedEvent;
import org.sonatype.nexus.cleanup.content.CleanupPolicyDeletedEvent;
import org.sonatype.nexus.cleanup.content.CleanupPolicyUpdatedEvent;
import org.sonatype.nexus.cleanup.storage.CleanupPolicy;
import org.sonatype.nexus.cleanup.storage.CleanupPolicyStorage;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.rest.WebApplicationMessageException;
import org.sonatype.nexus.validation.Validate;
import org.sonatype.nexus.validation.group.Update;

@Named
@Singleton
@Path(value="/v1/cleanup-policies")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class CleanupApiResourcePro
extends ComponentSupport
implements Resource,
CleanupApiResourceDocPro {
    public static final String RESOURCE_URI = "/v1/cleanup-policies";
    public static final String POLICY_NOT_FOUND = "Cleanup policy with name %s not found";
    private final CleanupPolicyStorage cleanupPolicyStorage;
    private final CleanupPolicyResourceHelper cleanupPolicyResourceHelper;
    private final EventManager eventManager;

    @Inject
    public CleanupApiResourcePro(CleanupPolicyStorage cleanupPolicyStorage, CleanupPolicyResourceHelper cleanupPolicyResourceHelper, EventManager eventManager) {
        this.cleanupPolicyStorage = Objects.requireNonNull(cleanupPolicyStorage);
        this.eventManager = Objects.requireNonNull(eventManager);
        this.cleanupPolicyResourceHelper = Objects.requireNonNull(cleanupPolicyResourceHelper);
    }

    @Override
    @POST
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    @Timed
    public Response create(@NotNull @Valid CleanupPolicyResourceXO cleanupPolicyResourceXO) {
        String policyName = cleanupPolicyResourceXO.getName();
        boolean exists = this.cleanupPolicyStorage.exists(policyName);
        if (exists) {
            throw new WebApplicationMessageException(Response.Status.CONFLICT, (Object)String.format("Policy '%s' already exists", policyName), "application/json");
        }
        this.cleanupPolicyResourceHelper.formatExistsValidator(cleanupPolicyResourceXO);
        this.cleanupPolicyResourceHelper.atLeastOneCriteriaHasSelected(cleanupPolicyResourceXO);
        this.cleanupPolicyResourceHelper.validateRetainAttributes(cleanupPolicyResourceXO);
        CleanupPolicy cleanupPolicyItem = this.cleanupPolicyResourceHelper.toCleanupPolicy(cleanupPolicyResourceXO);
        CleanupPolicy newPolicy = this.cleanupPolicyStorage.add(cleanupPolicyItem);
        CleanupPolicy cleanupPolicyToEvent = this.cleanupPolicyResourceHelper.toCleanupPolicy(cleanupPolicyResourceXO);
        this.eventManager.post((Object)new CleanupPolicyCreatedEvent(cleanupPolicyToEvent));
        CleanupPolicyResourceXO cleanupXO = this.cleanupPolicyResourceHelper.fromCleanupPolicy(newPolicy);
        return Response.status((int)201).entity((Object)cleanupXO).build();
    }

    @Override
    @GET
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:settings:read"})
    @Timed
    public Response getAll() {
        List allPolicies = this.cleanupPolicyStorage.getAll().stream().map(this.cleanupPolicyResourceHelper::fromCleanupPolicy).collect(Collectors.toList());
        return Response.ok(allPolicies).build();
    }

    @Override
    @GET
    @Path(value="{name}")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:settings:read"})
    @Timed
    public Response getCleanupPolicyByName(@PathParam(value="name") String cleanupPolicyName) {
        CleanupPolicy cleanupPolicy = this.cleanupPolicyStorage.get(cleanupPolicyName);
        if (cleanupPolicy == null) {
            throw new WebApplicationMessageException(Response.Status.NOT_FOUND, (Object)String.format(POLICY_NOT_FOUND, cleanupPolicyName), "application/json");
        }
        CleanupPolicyResourceXO policyResourceXO = this.cleanupPolicyResourceHelper.fromCleanupPolicy(cleanupPolicy);
        return Response.ok((Object)policyResourceXO).build();
    }

    @Override
    @DELETE
    @Path(value="{name}")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    @Timed
    public Response deletePolicyByName(@PathParam(value="name") String name) {
        CleanupPolicy cleanupPolicy = this.cleanupPolicyStorage.get(name);
        if (cleanupPolicy == null) {
            throw new WebApplicationMessageException(Response.Status.NOT_FOUND, (Object)String.format(POLICY_NOT_FOUND, name), "application/json");
        }
        this.cleanupPolicyStorage.remove(cleanupPolicy);
        this.eventManager.post((Object)new CleanupPolicyDeletedEvent(cleanupPolicy));
        return Response.noContent().build();
    }

    @Override
    @PUT
    @Path(value="/{policyName}")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    @Timed
    @Validate(groups={Update.class, Default.class})
    public Response update(@PathParam(value="policyName") String policyName, @NotNull @Valid CleanupPolicyResourceXO cleanupPolicyResourceXO) {
        CleanupPolicy oldCleanupPolicy = this.cleanupPolicyStorage.get(policyName);
        if (oldCleanupPolicy == null) {
            throw new WebApplicationMessageException(Response.Status.NOT_FOUND, (Object)String.format(POLICY_NOT_FOUND, policyName), "application/json");
        }
        cleanupPolicyResourceXO.setName(policyName);
        this.cleanupPolicyResourceHelper.formatExistsValidator(cleanupPolicyResourceXO);
        this.cleanupPolicyResourceHelper.atLeastOneCriteriaHasSelected(cleanupPolicyResourceXO);
        this.cleanupPolicyResourceHelper.validateRetainAttributes(cleanupPolicyResourceXO);
        this.cleanupPolicyResourceHelper.validateFormatNotChangedIfInUse(cleanupPolicyResourceXO, oldCleanupPolicy);
        oldCleanupPolicy.setName(cleanupPolicyResourceXO.getName());
        oldCleanupPolicy.setNotes(cleanupPolicyResourceXO.getNotes());
        oldCleanupPolicy.setMode("delete");
        oldCleanupPolicy.setFormat(cleanupPolicyResourceXO.getFormat());
        oldCleanupPolicy.setCriteria(this.cleanupPolicyResourceHelper.toCriteriaMap(cleanupPolicyResourceXO));
        this.cleanupPolicyStorage.update(oldCleanupPolicy);
        this.eventManager.post((Object)new CleanupPolicyUpdatedEvent(oldCleanupPolicy));
        return Response.noContent().build();
    }
}

