/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cleanup.storage.event;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.cleanup.storage.CleanupPolicy;
import org.sonatype.nexus.cleanup.storage.event.CleanupPolicyDeletedEvent;
import org.sonatype.nexus.cleanup.storage.event.CleanupPolicyEvent;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.manager.RepositoryManager;

@Singleton
@Named
public class CleanupPolicyEventHandler
extends ComponentSupport
implements EventAware,
EventAware.Asynchronous {
    private final RepositoryManager repositoryManager;

    @Inject
    public CleanupPolicyEventHandler(RepositoryManager repositoryManager) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(CleanupPolicyDeletedEvent event) {
        if (this.shouldProcess(event)) {
            CleanupPolicy cleanupPolicy = event.getCleanupPolicy();
            this.repositoryManager.browseForCleanupPolicy(cleanupPolicy.getName()).forEach(repository -> this.remove(repository.getConfiguration().copy(), cleanupPolicy));
        }
    }

    private void remove(Configuration configuration, CleanupPolicy cleanupPolicy) {
        try {
            this.removeFromConfigurationIfHasCleanupPolicy(configuration, cleanupPolicy);
            this.repositoryManager.update(configuration);
            this.log.info("Removed Cleanup Policy {} from Repository {}", (Object)cleanupPolicy.getName(), (Object)configuration.getRepositoryName());
        }
        catch (Exception e) {
            this.log.error("Unable to remove Cleanup Policy {} from Repository {}", new Object[]{cleanupPolicy.getName(), configuration.getRepositoryName(), e});
            throw new RuntimeException(e);
        }
    }

    private boolean shouldProcess(CleanupPolicyEvent event) {
        Preconditions.checkNotNull((Object)event);
        return event.isLocal();
    }

    private void removeFromConfigurationIfHasCleanupPolicy(Configuration configuration, CleanupPolicy cleanupPolicy) {
        Map cleanup;
        Map attributes = configuration.getAttributes();
        if (Objects.nonNull(attributes) && Objects.nonNull(cleanup = (Map)attributes.get("cleanup"))) {
            this.removeAttributeOrRemoveFromCleanupIfCleanupPolicyPresent(attributes, cleanup, cleanupPolicy);
        }
    }

    private void removeAttributeOrRemoveFromCleanupIfCleanupPolicyPresent(Map<String, Map<String, Object>> attributes, Map<String, Object> cleanup, CleanupPolicy cleanupPolicy) {
        HashSet<String> policyNames = new HashSet<String>((Collection)cleanup.get("policyName"));
        if (policyNames.removeIf(policyName -> policyName.equals(cleanupPolicy.getName()))) {
            if (policyNames.isEmpty()) {
                attributes.remove("cleanup");
            } else {
                cleanup.put("policyName", policyNames);
            }
        }
    }
}

