/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cleanup.storage;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.cleanup.internal.storage.CleanupPolicyData;
import org.sonatype.nexus.cleanup.storage.CleanupPolicy;
import org.sonatype.nexus.cleanup.storage.CleanupPolicyStorage;
import org.sonatype.nexus.supportzip.ExportConfigData;
import org.sonatype.nexus.supportzip.ImportData;
import org.sonatype.nexus.supportzip.datastore.JsonExporter;

@Named(value="cleanupPolicyExport")
@Singleton
public class CleanupPolicyExport
extends JsonExporter
implements ExportConfigData,
ImportData {
    private final CleanupPolicyStorage policyStorage;

    @Inject
    public CleanupPolicyExport(CleanupPolicyStorage policyStorage) {
        this.policyStorage = policyStorage;
    }

    public void export(File file) throws IOException {
        this.log.debug("Export CleanupPolicy data to {}", (Object)file);
        List<CleanupPolicy> cleanupPolicies = this.policyStorage.getAll();
        this.exportToJson(cleanupPolicies, file);
    }

    public void restore(File file) throws IOException {
        this.log.debug("Restoring CleanupPolicy data from {}", (Object)file);
        this.importFromJson(file, CleanupPolicyData.class).forEach(this.policyStorage::add);
    }
}

