/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cleanup.storage;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.sonatype.nexus.cleanup.storage.CleanupPolicyReleaseType;
import org.sonatype.nexus.cleanup.storage.config.CleanupPolicyAssetNamePattern;
import org.sonatype.nexus.common.text.Strings2;

public class CleanupPolicyCriteria {
    private static final long DAY_IN_SECONDS = TimeUnit.DAYS.toSeconds(1L);
    private final Integer lastBlobUpdated;
    private final Integer lastDownloaded;
    private final CleanupPolicyReleaseType releaseType;
    @CleanupPolicyAssetNamePattern
    private final String regex;
    private final Integer retain;
    private final String sortBy;

    public CleanupPolicyCriteria(Integer lastBlobUpdated, Integer lastDownloaded, CleanupPolicyReleaseType releaseType, String regex, Integer retain, String sortBy) {
        this.lastBlobUpdated = lastBlobUpdated;
        this.lastDownloaded = lastDownloaded;
        this.releaseType = releaseType;
        this.regex = regex;
        this.retain = retain;
        this.sortBy = sortBy;
    }

    public static CleanupPolicyCriteria fromMap(Map<String, String> criteriaMap) {
        return new CleanupPolicyCriteria(CleanupPolicyCriteria.getIntegerFromCriteriaMap(criteriaMap, "lastBlobUpdated"), CleanupPolicyCriteria.getIntegerFromCriteriaMap(criteriaMap, "lastDownloaded"), CleanupPolicyCriteria.getReleaseType(criteriaMap), criteriaMap.get("regex"), CleanupPolicyCriteria.getIntegerFromCriteriaMap(criteriaMap, "retain"), criteriaMap.get("sortBy"));
    }

    public static Map<String, String> toMap(CleanupPolicyCriteria criteria) {
        String value;
        HashMap criteriaMap = Maps.newHashMap();
        if (Objects.nonNull(criteria.lastBlobUpdated)) {
            value = String.valueOf((long)criteria.lastBlobUpdated.intValue() * DAY_IN_SECONDS);
            criteriaMap.put("lastBlobUpdated", value);
        }
        if (Objects.nonNull(criteria.lastDownloaded)) {
            value = String.valueOf((long)criteria.lastDownloaded.intValue() * DAY_IN_SECONDS);
            criteriaMap.put("lastDownloaded", value);
        }
        if (Objects.nonNull((Object)criteria.releaseType)) {
            value = Boolean.toString(criteria.releaseType == CleanupPolicyReleaseType.PRERELEASES);
            criteriaMap.put("isPrerelease", value);
        }
        if (Objects.nonNull(criteria.regex)) {
            criteriaMap.put("regex", criteria.regex);
        }
        if (Objects.nonNull(criteria.retain)) {
            value = String.valueOf(criteria.retain);
            criteriaMap.put("retain", value);
        }
        if (Objects.nonNull(criteria.sortBy)) {
            criteriaMap.put("sortBy", criteria.sortBy);
        }
        return criteriaMap;
    }

    @Nullable
    private static Integer getIntegerFromCriteriaMap(Map<String, String> criteriaMap, String criteria) {
        String value = criteriaMap.get(criteria);
        if (Strings2.notBlank((String)value)) {
            return Integer.parseInt(value) / (int)DAY_IN_SECONDS;
        }
        return null;
    }

    @Nullable
    private static CleanupPolicyReleaseType getReleaseType(Map<String, String> criteriaMap) {
        String value = criteriaMap.get("isPrerelease");
        if (Strings2.notBlank((String)value)) {
            return Boolean.parseBoolean(value) ? CleanupPolicyReleaseType.PRERELEASES : CleanupPolicyReleaseType.RELEASES;
        }
        return null;
    }

    public String toString() {
        return new StringJoiner(", ", String.valueOf(CleanupPolicyCriteria.class.getSimpleName()) + "[", "]").add("lastBlobUpdated=" + this.lastBlobUpdated).add("lastDownloaded=" + this.lastDownloaded).add("releaseType=" + (Object)((Object)this.releaseType)).add("regex='" + this.regex + "'").add("retain='" + this.retain + "'").add("sortBy=" + this.sortBy).toString();
    }
}

