/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cleanup.internal.task;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.cleanup.service.CleanupService;
import org.sonatype.nexus.logging.task.TaskLogType;
import org.sonatype.nexus.logging.task.TaskLogging;
import org.sonatype.nexus.scheduling.TaskSupport;

@Named
@TaskLogging(value=TaskLogType.TASK_LOG_ONLY)
public class CleanupTask
extends TaskSupport {
    private final CleanupService cleanupService;

    @Inject
    public CleanupTask(CleanupService cleanupService) {
        this.cleanupService = (CleanupService)Preconditions.checkNotNull((Object)cleanupService);
    }

    protected Object execute() {
        this.log.info("Starting cleanup");
        this.cleanupService.cleanup(() -> ((CleanupTask)this).isCanceled());
        if (this.isCanceled()) {
            this.log.info("Cleanup was cancelled before it could finish");
        } else {
            this.log.info("Cleanup finished");
        }
        return null;
    }

    public String getMessage() {
        return "Run repository cleanup";
    }
}

