/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cleanup.internal.storage;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.cleanup.internal.storage.CleanupPolicyDAO;
import org.sonatype.nexus.cleanup.internal.storage.CleanupPolicyData;
import org.sonatype.nexus.cleanup.storage.CleanupPolicy;
import org.sonatype.nexus.cleanup.storage.CleanupPolicyStorage;
import org.sonatype.nexus.cleanup.storage.event.CleanupPolicyDeletedEvent;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.datastore.ConfigStoreSupport;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.transaction.Transactional;

@Named(value="mybatis")
@Singleton
public class CleanupPolicyStorageImpl
extends ConfigStoreSupport<CleanupPolicyDAO>
implements CleanupPolicyStorage {
    private final EventManager eventManager;

    @Inject
    public CleanupPolicyStorageImpl(DataSessionSupplier sessionSupplier, EventManager eventManager) {
        super(sessionSupplier);
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
    }

    @Override
    public CleanupPolicy newCleanupPolicy() {
        return new CleanupPolicyData();
    }

    @Override
    @Transactional
    public List<CleanupPolicy> getAll() {
        return ImmutableList.copyOf((Iterable)((CleanupPolicyDAO)this.dao()).browse());
    }

    @Override
    @Transactional
    public List<CleanupPolicy> getAllByFormat(String format) {
        return ImmutableList.copyOf(((CleanupPolicyDAO)this.dao()).browseByFormat(format));
    }

    @Override
    @Transactional
    public long count() {
        return ((CleanupPolicyDAO)this.dao()).count();
    }

    @Override
    @Transactional
    public CleanupPolicy add(CleanupPolicy policy) {
        ((CleanupPolicyDAO)this.dao()).create((CleanupPolicyData)policy);
        return policy;
    }

    @Override
    @Transactional
    public CleanupPolicy get(String policyName) {
        return ((CleanupPolicyDAO)this.dao()).read(policyName).orElse(null);
    }

    @Override
    @Transactional
    public boolean exists(String policyName) {
        return ((CleanupPolicyDAO)this.dao()).read(policyName).isPresent();
    }

    @Override
    @Transactional
    public CleanupPolicy update(CleanupPolicy policy) {
        ((CleanupPolicyDAO)this.dao()).update((CleanupPolicyData)policy);
        return policy;
    }

    @Override
    public void remove(CleanupPolicy policy) {
        this.doRemove(policy);
        this.postDeletedEvent(policy);
    }

    @Transactional
    protected void doRemove(CleanupPolicy policy) {
        ((CleanupPolicyDAO)this.dao()).delete(policy.getName());
    }

    private void postDeletedEvent(final CleanupPolicy policy) {
        this.eventManager.post((Object)new CleanupPolicyDeletedEvent(){

            @Override
            public boolean isLocal() {
                return true;
            }

            @Override
            public CleanupPolicy getCleanupPolicy() {
                return policy;
            }
        });
    }
}

