/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cleanup.content;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.audit.AuditData;
import org.sonatype.nexus.audit.AuditorSupport;
import org.sonatype.nexus.cleanup.content.CleanupPolicyCreatedEvent;
import org.sonatype.nexus.cleanup.content.CleanupPolicyDeletedEvent;
import org.sonatype.nexus.cleanup.content.CleanupPolicyEvent;
import org.sonatype.nexus.cleanup.content.CleanupPolicyUpdatedEvent;
import org.sonatype.nexus.cleanup.storage.CleanupPolicy;
import org.sonatype.nexus.common.event.EventAware;

@Named
@Singleton
public class CleanupPolicyAuditor
extends AuditorSupport
implements EventAware {
    public static final String DOMAIN = "cleanupPolicy";

    public CleanupPolicyAuditor() {
        this.registerType(CleanupPolicyCreatedEvent.class, "created");
        this.registerType(CleanupPolicyUpdatedEvent.class, "updated");
        this.registerType(CleanupPolicyDeletedEvent.class, "deleted");
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(CleanupPolicyEvent event) {
        if (this.isRecording()) {
            CleanupPolicy cleanupPolicy = event.getCleanupPolicy();
            AuditData data = this.getPolicyAuditData(event, cleanupPolicy);
            this.record(data);
        }
    }

    private AuditData getPolicyAuditData(CleanupPolicyEvent event, CleanupPolicy cleanupPolicy) {
        AuditData data = new AuditData();
        data.setDomain(DOMAIN);
        data.setType(this.type(event.getClass()));
        data.setContext(cleanupPolicy.getName());
        Map attributes = data.getAttributes();
        attributes.put("format", cleanupPolicy.getFormat());
        attributes.put("description", cleanupPolicy.getNotes());
        attributes.put("criteria", cleanupPolicy.getCriteria());
        return data;
    }
}

