/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.versionspecific;

import com.install4j.api.launcher.StartupNotification;
import com.install4j.runtime.alert.AlertType;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.versionspecific.Java8Helper;
import java.awt.Desktop;
import java.awt.Image;
import java.awt.desktop.AboutEvent;
import java.awt.desktop.AboutHandler;
import java.awt.desktop.OpenFilesEvent;
import java.awt.desktop.OpenFilesHandler;
import java.awt.desktop.PreferencesEvent;
import java.awt.desktop.PreferencesHandler;
import java.awt.desktop.QuitEvent;
import java.awt.desktop.QuitHandler;
import java.awt.desktop.QuitResponse;
import java.awt.image.BufferedImage;
import java.awt.image.MultiResolutionImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Predicate;
import javafx.stage.Window;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.basic.BasicOptionPaneUI;

public class Java9Helper
extends Java8Helper {
    @Override
    public void requestForeground() {
        Desktop desktop = Desktop.getDesktop();
        if (desktop.isSupported(Desktop.Action.APP_REQUEST_FOREGROUND)) {
            desktop.requestForeground(true);
        }
    }

    @Override
    public void setMacStartupListener(final StartupNotification.Listener startupListener) {
        Desktop desktop = Desktop.getDesktop();
        if (startupListener != null && desktop.isSupported(Desktop.Action.APP_OPEN_FILE)) {
            desktop.setOpenFileHandler(new OpenFilesHandler(){

                @Override
                public void openFiles(OpenFilesEvent e) {
                    for (File file : e.getFiles()) {
                        startupListener.startupPerformed(file.getAbsolutePath());
                    }
                }
            });
        }
    }

    @Override
    public void setMacHandleQuit(final boolean handleQuit) {
        Desktop desktop = Desktop.getDesktop();
        if (desktop.isSupported(Desktop.Action.APP_QUIT_HANDLER)) {
            desktop.setQuitHandler(new QuitHandler(){

                @Override
                public void handleQuitRequestWith(QuitEvent e, QuitResponse response) {
                    if (handleQuit) {
                        response.performQuit();
                    } else {
                        response.cancelQuit();
                    }
                }
            });
        }
    }

    @Override
    public void setMacQuitHandler(final Runnable runnable) {
        Desktop desktop = Desktop.getDesktop();
        if (runnable != null && desktop.isSupported(Desktop.Action.APP_QUIT_HANDLER)) {
            desktop.setQuitHandler(new QuitHandler(){

                @Override
                public void handleQuitRequestWith(QuitEvent e, QuitResponse response) {
                    response.cancelQuit();
                    runnable.run();
                }
            });
        }
    }

    @Override
    public void setMacAboutHandler(final Runnable runnable) {
        Desktop desktop = Desktop.getDesktop();
        if (runnable != null && desktop.isSupported(Desktop.Action.APP_ABOUT)) {
            desktop.setAboutHandler(new AboutHandler(){

                @Override
                public void handleAbout(AboutEvent e) {
                    runnable.run();
                }
            });
        }
    }

    @Override
    public void setMacPreferencesHandler(final Runnable runnable) {
        Desktop desktop = Desktop.getDesktop();
        if (runnable != null && desktop.isSupported(Desktop.Action.APP_PREFERENCES)) {
            desktop.setPreferencesHandler(new PreferencesHandler(){

                @Override
                public void handlePreferences(PreferencesEvent e) {
                    runnable.run();
                }
            });
        }
    }

    @Override
    public void addReads(String moduleName) {
        try {
            Optional<Module> optionalModule = ModuleLayer.boot().findModule(moduleName);
            if (optionalModule.isPresent()) {
                Java9Helper.class.getModule().addReads(optionalModule.get());
            }
        }
        catch (Throwable t) {
            Logger.getInstance().log(t);
        }
    }

    @Override
    public long getPid() {
        try {
            return ((ProcessHandle)ProcessHandle.class.getMethod("current", new Class[0]).invoke(null, new Object[0])).pid();
        }
        catch (Throwable e) {
            return super.getPid();
        }
    }

    @Override
    public boolean isJavaFxWindowShown() {
        try {
            return Window.getWindows().stream().anyMatch(new Predicate<Window>(){

                @Override
                public boolean test(Window window) {
                    return window.isShowing();
                }
            });
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static void main(String[] args) throws ClassNotFoundException, UnsupportedLookAndFeelException, InstantiationException, IllegalAccessException, IOException {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        for (AlertType alertType : AlertType.values()) {
            ImageIcon icon = (ImageIcon)new CustomOptionPaneUI().getIconForType(alertType.getOptionType());
            Image sourceImage = icon.getImage();
            if (sourceImage instanceof MultiResolutionImage) {
                BufferedImage image = (BufferedImage)((MultiResolutionImage)((Object)sourceImage)).getResolutionVariant(64.0, 64.0);
                Java9Helper.writeImage(alertType, "@2x", image);
                continue;
            }
            Java9Helper.writeImage(alertType, "", (BufferedImage)sourceImage);
        }
    }

    private static void writeImage(AlertType alertType, String postFix, BufferedImage image) throws IOException {
        ImageIO.write((RenderedImage)image, "png", new File("C:\\Users\\ingo\\projects\\install4j\\modules\\install4j_runtime\\resources\\com\\install4j\\runtime\\installer\\frontend\\icons", "alert_windows_" + alertType.name().toLowerCase(Locale.ENGLISH) + postFix + ".png"));
    }

    private static class CustomOptionPaneUI
    extends BasicOptionPaneUI {
        private CustomOptionPaneUI() {
            this.installUI(new JOptionPane());
        }

        @Override
        protected Icon getIconForType(int messageType) {
            return super.getIconForType(messageType);
        }
    }
}

