/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.config;

import com.install4j.api.styles.Style;
import com.install4j.runtime.installer.config.AbstractBeanConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.StyleBeanConfig;
import com.install4j.runtime.installer.config.WrapperBeanConfig;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;

public class OverriddenStyleBeanConfig
extends StyleBeanConfig {
    private List<WrapperBeanConfig> overriddenBeanConfigs;
    private String referenceId;
    private Style instance;

    @Override
    public Style getOrInstantiateStyle(boolean suppressErrors) {
        if (this.instance == null) {
            this.instance = (Style)this.getDelegate().instantiateBean(suppressErrors);
        }
        return this.instance;
    }

    @Override
    public List<WrapperBeanConfig> getOverriddenBeanConfigs() {
        return this.overriddenBeanConfigs;
    }

    @Override
    public boolean isInstantiated() {
        return true;
    }

    @Override
    public void batchInstantiate() {
        for (WrapperBeanConfig overriddenBeanConfig : this.overriddenBeanConfigs) {
            overriddenBeanConfig.batchInstantiate();
        }
    }

    @Override
    public List<AbstractBeanConfig> getFormComponentConfigs() {
        return this.getDelegate().getFormComponentConfigs();
    }

    @Override
    protected void read(Element element) {
        super.read(element);
        this.referenceId = OverriddenStyleBeanConfig.readAttribute(element, "referenceId", this.referenceId);
        this.readOverriddenBeans(element);
    }

    private void readOverriddenBeans(Element element) {
        Element overriddenStylesElement = OverriddenStyleBeanConfig.findChild(element, "overriddenBeans");
        LinkedList<WrapperBeanConfig> overriddenBeanConfigs = new LinkedList<WrapperBeanConfig>();
        if (overriddenStylesElement != null) {
            for (Element beanElement : OverriddenStyleBeanConfig.childElements(overriddenStylesElement)) {
                WrapperBeanConfig beanConfig = (WrapperBeanConfig)OverriddenStyleBeanConfig.readNestedBeanConfig(beanElement);
                if (beanConfig == null) continue;
                overriddenBeanConfigs.add(beanConfig);
            }
        }
        this.overriddenBeanConfigs = Collections.unmodifiableList(overriddenBeanConfigs);
    }

    private StyleBeanConfig getDelegate() {
        return InstallerConfig.getCurrentInstance().getStyleConfigById(this.referenceId);
    }
}

