/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.rest.model;

import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import javax.validation.constraints.NotBlank;
import org.sonatype.nexus.repository.config.RepositoryTypeHosted;
import org.sonatype.nexus.validation.constraint.UrlString;
import org.sonatype.nexus.validation.group.Create;
import org.sonatype.nexus.validation.group.Update;

public class ReplicationConnectionXO {
    @ApiModelProperty(value="Connection Id", readOnly=true)
    private String id;
    @ApiModelProperty(value="Replication Connection Name", required=true)
    private String name;
    @ApiModelProperty(value="Source Repository Name", example="maven-releases", required=true)
    @NotBlank
    @RepositoryTypeHosted(groups={Create.class, Update.class})
    private String sourceRepositoryName;
    @ApiModelProperty(value="Destination Instance URL", example="https://example.com/", required=true)
    @UrlString
    @NotBlank
    private String destinationInstanceUrl;
    @ApiModelProperty(value="Destination Instance Username", example="admin", required=false)
    private String destinationInstanceUsername;
    @ApiModelProperty(value="Destination Instance Password", example="admin123", required=false)
    private String destinationInstancePassword;
    @ApiModelProperty(value="Destination Repository Name", example="maven-releases", required=true)
    @NotBlank
    private String destinationRepositoryName;
    @ApiModelProperty(value="Regular expressions used to filter the repository content that is replicated")
    private List<String> contentRegexes;
    @ApiModelProperty(value="Boolean used to configure if a replication connection should include existing content")
    private boolean includeExistingContent;
    @ApiModelProperty(value="Boolean used to configure if a replication connection should use the Nexus Repository Truststore")
    private boolean useTrustStore;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSourceRepositoryName() {
        return this.sourceRepositoryName;
    }

    public void setSourceRepositoryName(String sourceRepositoryName) {
        this.sourceRepositoryName = sourceRepositoryName;
    }

    public String getDestinationInstanceUrl() {
        return this.destinationInstanceUrl;
    }

    public void setDestinationInstanceUrl(String destinationInstanceUrl) {
        this.destinationInstanceUrl = destinationInstanceUrl;
    }

    public String getDestinationInstanceUsername() {
        return this.destinationInstanceUsername;
    }

    public void setDestinationInstanceUsername(String destinationInstanceUsername) {
        this.destinationInstanceUsername = destinationInstanceUsername;
    }

    public String getDestinationInstancePassword() {
        return this.destinationInstancePassword;
    }

    public void setDestinationInstancePassword(String destinationInstancePassword) {
        this.destinationInstancePassword = destinationInstancePassword;
    }

    public String getDestinationRepositoryName() {
        return this.destinationRepositoryName;
    }

    public void setDestinationRepositoryName(String destinationRepositoryName) {
        this.destinationRepositoryName = destinationRepositoryName;
    }

    public List<String> getContentRegexes() {
        return this.contentRegexes;
    }

    public void setContentRegexes(List<String> contentRegexes) {
        this.contentRegexes = contentRegexes;
    }

    public boolean isIncludeExistingContent() {
        return this.includeExistingContent;
    }

    public void setIncludeExistingContent(boolean includeExistingContent) {
        this.includeExistingContent = includeExistingContent;
    }

    public boolean isUseTrustStore() {
        return this.useTrustStore;
    }

    public void setUseTrustStore(boolean useTrustStore) {
        this.useTrustStore = useTrustStore;
    }
}

