/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal.transfer.http.rest;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.replication.internal.ReplicationChecks;
import com.sonatype.nexus.replication.internal.pull.source.PullReplicationSourceService;
import com.sonatype.nexus.replication.internal.pull.source.SourceAssetsResponse;
import com.sonatype.nexus.replication.internal.transfer.http.rest.AssetApiException;
import com.sonatype.nexus.replication.rest.model.HttpPullRepositoryInfoXO;
import com.sonatype.nexus.replication.rest.model.HttpPullResponseXO;
import com.sonatype.nexus.repository.group.deploy.GroupWriteFacet;
import java.time.OffsetDateTime;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ApplicationVersion;
import org.sonatype.nexus.common.encoding.EncodingUtil;
import org.sonatype.nexus.common.time.UTC;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.AssetInfo;
import org.sonatype.nexus.repository.rest.api.RepositoryManagerRESTAdapter;
import org.sonatype.nexus.rest.Resource;

@Named
@Singleton
@Path(value="/internal/replication")
public class AssetApiResource
extends ComponentSupport
implements Resource {
    private final RepositoryManagerRESTAdapter repositoryManagerRESTAdapter;
    private final PullReplicationSourceService pullReplicationSourceService;
    private final ApplicationVersion applicationVersion;
    private final ReplicationChecks replicationChecks;
    public static final String RESOURCE_URI = "/internal/replication";

    @Inject
    public AssetApiResource(RepositoryManagerRESTAdapter repositoryManagerRESTAdapter, PullReplicationSourceService pullReplicationSourceService, ApplicationVersion applicationVersion, ReplicationChecks replicationChecks) {
        this.repositoryManagerRESTAdapter = (RepositoryManagerRESTAdapter)Preconditions.checkNotNull((Object)repositoryManagerRESTAdapter);
        this.pullReplicationSourceService = (PullReplicationSourceService)((Object)Preconditions.checkNotNull((Object)((Object)pullReplicationSourceService)));
        this.applicationVersion = (ApplicationVersion)Preconditions.checkNotNull((Object)applicationVersion);
        this.replicationChecks = (ReplicationChecks)((Object)Preconditions.checkNotNull((Object)((Object)replicationChecks)));
    }

    @GET
    @Path(value="/{repository}/info")
    @Produces(value={"application/json"})
    public HttpPullRepositoryInfoXO getRepositoryInfo(@PathParam(value="repository") String repositoryName) throws WebApplicationException {
        HttpPullRepositoryInfoXO response = new HttpPullRepositoryInfoXO();
        response.setApplicationVersion(this.applicationVersion.getVersion());
        Repository repository = this.repositoryManagerRESTAdapter.getRepository(repositoryName);
        String formatName = repository.getFormat().getValue();
        response.setFormatName(formatName);
        response.setReplicationEnabled(this.replicationChecks.isSourceFeatureEnabled() && this.replicationChecks.isFormatSupported(formatName));
        response.setGroupWriteMember(this.isGroupWriteRepository(repositoryName));
        response.setHostedRepository("hosted".equals(repository.getType().getValue()));
        return response;
    }

    private boolean isGroupWriteRepository(String repositoryName) {
        return this.repositoryManagerRESTAdapter.findContainingGroups(repositoryName).stream().map(groupName -> this.repositoryManagerRESTAdapter.getRepository(groupName).optionalFacet(GroupWriteFacet.class)).filter(Optional::isPresent).map(Optional::get).map(GroupWriteFacet::getWritableMember).filter(Objects::nonNull).anyMatch(repository -> repository.getName().equals(repositoryName));
    }

    @GET
    @Path(value="/{repository}/fetch")
    @Produces(value={"application/json"})
    public HttpPullResponseXO fetchAssets(@PathParam(value="repository") String repositoryName, @Nullable @QueryParam(value="addedToRepository") String addedToRepository, @QueryParam(value="regex") List<String> regexList) throws AssetApiException {
        OffsetDateTime addedToRepositoryDate;
        Repository repository = this.repositoryManagerRESTAdapter.getRepository(repositoryName);
        this.ensureReplicationAvailable(repositoryName, repository.getFormat().getValue());
        OffsetDateTime fetchDateTime = UTC.now();
        if (addedToRepository != null) {
            try {
                addedToRepositoryDate = OffsetDateTime.parse(addedToRepository);
            }
            catch (DateTimeParseException dateTimeParseException) {
                throw new AssetApiException(Response.Status.BAD_REQUEST, "addedToRepositoryDate param is not an offset date time");
            }
        } else {
            addedToRepositoryDate = fetchDateTime;
        }
        List<String> decodedRegexList = regexList.stream().map(EncodingUtil::urlDecode).collect(Collectors.toList());
        SourceAssetsResponse assetsResponse = this.pullReplicationSourceService.fetchAssets(repository, addedToRepositoryDate, decodedRegexList, fetchDateTime);
        HttpPullResponseXO response = new HttpPullResponseXO();
        response.setAddedToRepository(assetsResponse.getAddedToRepository());
        response.setAssetPaths(assetsResponse.getAssets().stream().map(AssetInfo::path).collect(Collectors.toList()));
        return response;
    }

    private boolean isSourceHosted(String repositoryName) {
        return this.repositoryManagerRESTAdapter.getRepository(repositoryName).getType().getValue().equals("hosted");
    }

    private void ensureReplicationAvailable(String repositoryName, String formatName) throws AssetApiException {
        if (!this.isSourceHosted(repositoryName)) {
            throw new AssetApiException(Response.Status.NOT_FOUND, "Content Replication is only supported for hosted source repositories");
        }
        if (!this.replicationChecks.isSourceFeatureEnabled()) {
            throw new AssetApiException(Response.Status.NOT_FOUND, "Content Replication is not available");
        }
        if (!this.replicationChecks.isFormatSupported(formatName)) {
            throw new AssetApiException(Response.Status.NOT_FOUND, String.format("Content Replication for %s is not supported", formatName));
        }
        if (formatName.equals("docker") && this.isGroupWriteRepository(repositoryName)) {
            throw new AssetApiException(Response.Status.CONFLICT, "Content Replication is not supported for docker within a group");
        }
    }
}

