/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal.tasks.datastore;

import com.sonatype.nexus.replication.ReplicationConnectionManager;
import com.sonatype.nexus.replication.ReplicationQueueManager;
import com.sonatype.nexus.replication.internal.tasks.ReplicationBackfillQueueService;
import com.sonatype.nexus.replication.internal.tasks.ReplicationBackfillQueueServiceSupport;
import java.util.function.BooleanSupplier;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentAssets;
import org.sonatype.nexus.repository.manager.RepositoryManager;

@Singleton
@Named
public class ReplicationBackfillQueueServiceImpl
extends ReplicationBackfillQueueServiceSupport
implements ReplicationBackfillQueueService {
    @Inject
    public ReplicationBackfillQueueServiceImpl(RepositoryManager repositoryManager, ReplicationQueueManager replicationQueueManager, ReplicationConnectionManager replicationConnectionManager, @Named(value="${nexus.replication.queue.backfill.pageSize:-1000}") @Named(value="${nexus.replication.queue.backfill.pageSize:-1000}") int pageSize) {
        super(repositoryManager, replicationQueueManager, replicationConnectionManager, pageSize);
    }

    @Override
    protected void doBackfill(Repository repository, String replicationConnectionId, BooleanSupplier shouldStopFunction) {
        FluentAssets assets = ((ContentFacet)repository.facet(ContentFacet.class)).assets();
        Continuation nextPage = assets.browse(this.getPageSize(), null);
        while (!nextPage.isEmpty()) {
            if (!this.walkPage(repository, replicationConnectionId, (Continuation<FluentAsset>)nextPage, shouldStopFunction)) break;
            nextPage = assets.browse(this.getPageSize(), nextPage.nextContinuationToken());
        }
    }

    private boolean walkPage(Repository repository, String replicationConnectionId, Continuation<FluentAsset> assets, BooleanSupplier shouldStopFunction) {
        for (FluentAsset asset : assets) {
            if (shouldStopFunction.getAsBoolean()) {
                this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Task cancelled, stopping processing");
                return false;
            }
            this.backfillAsset(repository, replicationConnectionId, asset);
        }
        return true;
    }

    private void backfillAsset(Repository repository, String replicationConnectionId, FluentAsset asset) {
        if (!asset.blob().isPresent()) {
            this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Skipping asset {} as it has no blob backing it.", (Object)asset.path());
        } else {
            this.backfillAsset(repository.getName(), replicationConnectionId, asset.path(), ((AssetBlob)asset.blob().get()).blobRef().getBlob());
        }
    }
}

