/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal.tasks;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.replication.internal.tasks.ReplicationBackfillQueueTaskManager;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.schedule.Now;
import org.sonatype.nexus.scheduling.schedule.Schedule;

@Singleton
@Named
public class ReplicationBackfillQueueTaskManagerImpl
extends ComponentSupport
implements ReplicationBackfillQueueTaskManager {
    private final TaskScheduler taskScheduler;

    @Inject
    public ReplicationBackfillQueueTaskManagerImpl(TaskScheduler taskScheduler) {
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
    }

    @Override
    public void backfillRepository(String repository) {
        if (this.taskScheduler.listsTasks().stream().noneMatch(info -> "replication.backfill.queue".equals(info.getConfiguration().getTypeId()) && repository.equals(info.getConfiguration().getString("repositoryName")))) {
            this.log.info("Launching task to add all assets in repository {} into the replication queue.", (Object)repository);
            TaskConfiguration configuration = this.taskScheduler.createTaskConfigurationInstance("replication.backfill.queue");
            configuration.setString("repositoryName", repository);
            Now schedule = this.taskScheduler.getScheduleFactory().now();
            this.taskScheduler.scheduleTask(configuration, (Schedule)schedule);
        } else {
            this.log.info("Not launching task to add all assets in repository {} into the replication queue as there is already an existing task.", (Object)repository);
        }
    }
}

