/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal.tasks;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.replication.ReplicationConnectionManager;
import com.sonatype.nexus.replication.db.model.ReplicationConnection;
import com.sonatype.nexus.replication.internal.tasks.ReplicationBackfillQueueService;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.RepositoryTaskSupport;
import org.sonatype.nexus.scheduling.Cancelable;

@Named
public class ReplicationBackfillQueueTask
extends RepositoryTaskSupport
implements Cancelable {
    private final ReplicationBackfillQueueService replicationBackfillQueueService;
    private final ReplicationConnectionManager replicationConnectionManager;

    @Inject
    public ReplicationBackfillQueueTask(ReplicationBackfillQueueService replicationBackfillQueueService, ReplicationConnectionManager replicationConnectionManager) {
        this.replicationBackfillQueueService = (ReplicationBackfillQueueService)Preconditions.checkNotNull((Object)replicationBackfillQueueService);
        this.replicationConnectionManager = (ReplicationConnectionManager)Preconditions.checkNotNull((Object)replicationConnectionManager);
    }

    protected void execute(Repository repository) {
        String replicationConnectionId = this.getConfiguration().getString("replicationId");
        if (replicationConnectionId != null) {
            this.replicationBackfillQueueService.backfillByReplicationConnection(replicationConnectionId, () -> ((ReplicationBackfillQueueTask)this).isCanceled());
        } else {
            this.replicationBackfillQueueService.backfill(repository.getName(), () -> ((ReplicationBackfillQueueTask)this).isCanceled());
        }
    }

    protected boolean appliesTo(Repository repository) {
        String replicationConnectionId = this.getConfiguration().getString("replicationId");
        if (replicationConnectionId != null) {
            return this.replicationConnectionManager.getById(replicationConnectionId).map(connection -> connection.getSourceRepositoryName().equals(repository.getName())).orElse(false);
        }
        Collection<ReplicationConnection> replicationConnectionList = this.replicationConnectionManager.list();
        return replicationConnectionList.stream().anyMatch(rc -> repository.getName().equals(rc.getSourceRepositoryName()));
    }

    public String getMessage() {
        return "Add all items from selected repository into the replication queue.";
    }
}

