/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal.pull.source;

import com.google.common.annotations.VisibleForTesting;
import com.sonatype.nexus.replication.internal.pull.source.SourceAssetsResponse;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.shiro.authz.Permission;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.AssetInfo;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.store.AssetStore;
import org.sonatype.nexus.repository.security.RepositoryViewPermission;
import org.sonatype.nexus.repository.selector.ContentAuthHelper;
import org.sonatype.nexus.security.SecurityHelper;
import org.sonatype.nexus.selector.SelectorConfiguration;
import org.sonatype.nexus.selector.SelectorFilterBuilder;
import org.sonatype.nexus.selector.SelectorManager;

@Named
public class PullReplicationSourceService
extends ComponentSupport {
    private final SecurityHelper securityHelper;
    private final SelectorManager selectorManager;
    private final SelectorFilterBuilder selectorFilterBuilder;
    private final ContentAuthHelper contentAuthHelper;
    private final int batchSize;

    @Inject
    public PullReplicationSourceService(SecurityHelper securityHelper, SelectorManager selectorManager, SelectorFilterBuilder selectorFilterBuilder, ContentAuthHelper contentAuthHelper, @Named(value="${nexus.replication.pull.batchSize:-512}") @Named(value="${nexus.replication.pull.batchSize:-512}") int batchSize) {
        this.securityHelper = securityHelper;
        this.selectorManager = selectorManager;
        this.selectorFilterBuilder = selectorFilterBuilder;
        this.contentAuthHelper = contentAuthHelper;
        this.batchSize = batchSize;
    }

    public SourceAssetsResponse fetchAssets(Repository repository, @Nullable OffsetDateTime addedToRepository, List<String> regexList, OffsetDateTime fetchDateTime) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(regexList);
        String repositoryName = repository.getName();
        String format = repository.getFormat().getValue();
        this.log.debug("Fetching assets from {}", (Object)repositoryName);
        SourceAssetsResponse response = new SourceAssetsResponse();
        List selectors = Collections.emptyList();
        if (!this.hasReadPermission(repositoryName, format)) {
            selectors = this.selectorManager.browseActive(Collections.singletonList(repositoryName), Collections.singletonList(format));
            if (selectors.isEmpty()) {
                this.log.debug("No access to fetch assets from {}", (Object)repositoryName);
                response.setAddedToRepository(this.toDate(fetchDateTime));
                return response;
            }
            this.log.debug("Applying content selectors to fetched assets from {}", (Object)repositoryName);
        }
        HashMap<String, Object> filterParameters = new HashMap<String, Object>();
        String filter = this.selectorFilterBuilder.buildFilter(format, "path", selectors, filterParameters);
        boolean hasJexl = selectors.stream().anyMatch(this::isJexl);
        List<Object> assets = this.findUpdatedAssets(repository, addedToRepository, regexList, filter, filterParameters);
        if (assets.isEmpty()) {
            response.setAddedToRepository(this.toDate(fetchDateTime));
        } else {
            AssetInfo lastAsset = assets.get(assets.size() - 1);
            response.setAddedToRepository(this.toDate(lastAsset.addedToRepository()));
        }
        int originalSize = assets.size();
        if (hasJexl && (assets = assets.stream().filter(asset -> this.contentAuthHelper.checkPathPermissionsJexlOnly(asset.path(), format, new String[]{repositoryName})).collect(Collectors.toList())).size() != originalSize) {
            this.log.debug("Applying JEXL content selectors for {} ({} -> {} results)", new Object[]{repositoryName, originalSize, assets.size()});
        }
        if (this.log.isDebugEnabled()) {
            if (assets.size() == originalSize) {
                this.log.debug("{} assets fetched", (Object)assets.size());
            } else {
                this.log.debug("{} assets fetched (filtered from {})", (Object)assets.size(), (Object)originalSize);
            }
        }
        response.setAssets(assets);
        return response;
    }

    @VisibleForTesting
    protected List<AssetInfo> findUpdatedAssets(Repository repository, OffsetDateTime addedToRepository, List<String> regexList, String filter, Map<String, Object> filterParameters) {
        ContentFacetSupport contentFacet = (ContentFacetSupport)repository.facet(ContentFacet.class);
        AssetStore assetStore = contentFacet.stores().assetStore;
        return assetStore.findUpdatedAssets(contentFacet.contentRepositoryId().intValue(), addedToRepository, regexList, filter, filterParameters, this.batchSize);
    }

    private boolean hasReadPermission(String repositoryName, String format) {
        return this.securityHelper.anyPermitted(new Permission[]{new RepositoryViewPermission(format, repositoryName, new String[]{"read"})});
    }

    private boolean isJexl(SelectorConfiguration selectorConfiguration) {
        return "jexl".equals(selectorConfiguration.getType());
    }

    private Date toDate(OffsetDateTime dateTime) {
        return Date.from(dateTime.toInstant());
    }
}

