/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal.pull;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.sonatype.nexus.replication.internal.pull.SourceConnection;
import com.sonatype.nexus.replication.internal.pull.SourceUnavailableException;
import com.sonatype.nexus.replication.rest.model.HttpPullRepositoryInfoXO;
import com.sonatype.nexus.replication.rest.model.HttpPullResponseXO;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.common.encoding.EncodingUtil;
import org.sonatype.nexus.httpclient.HttpClientManager;
import org.sonatype.nexus.httpclient.HttpClientPlan;
import org.sonatype.nexus.httpclient.PreemptiveAuthHttpRequestInterceptor;
import org.sonatype.nexus.httpclient.config.AuthenticationConfiguration;
import org.sonatype.nexus.httpclient.config.ConfigurationCustomizer;
import org.sonatype.nexus.httpclient.config.ConnectionConfiguration;
import org.sonatype.nexus.httpclient.config.HttpClientConfiguration;
import org.sonatype.nexus.httpclient.config.UsernameAuthenticationConfiguration;

@Named
public class SourceInstanceConnector
extends ComponentSupport {
    ObjectMapper objectMapper = new ObjectMapper();
    private final HttpClientManager httpClientManager;

    @Inject
    public SourceInstanceConnector(HttpClientManager httpClientManager) {
        this.httpClientManager = httpClientManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HttpPullResponseXO fetchAssets(SourceConnection sourceConnection, @Nullable OffsetDateTime addedToRepository, @Nullable List<String> regexList) throws SourceUnavailableException {
        URI fetchUri = this.buildFetchUri(sourceConnection, Objects.toString(addedToRepository, null), regexList);
        HttpGet request = new HttpGet(fetchUri);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (CloseableHttpClient client = this.createHttpClient(sourceConnection);){
                CloseableHttpResponse response = client.execute((HttpUriRequest)request);
                try {
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode != 200) throw new HttpResponseException(statusCode, response.getStatusLine().getReasonPhrase());
                    HttpPullResponseXO httpPullResponseXO = (HttpPullResponseXO)this.objectMapper.readValue(response.getEntity().getContent(), HttpPullResponseXO.class);
                    return httpPullResponseXO;
                }
                finally {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new SourceUnavailableException("Unable to fetch list of assets", e);
        }
    }

    @VisibleForTesting
    URI buildFetchUri(SourceConnection sourceConnection, @Nullable String addedToRepository, @Nullable List<String> regexList) throws SourceUnavailableException {
        try {
            URIBuilder uriBuilder = new URIBuilder(String.valueOf(sourceConnection.getBaseUrl()) + "/service/rest/internal/replication/" + sourceConnection.getRepositoryName() + "/fetch");
            if (addedToRepository != null) {
                uriBuilder.addParameter("addedToRepository", addedToRepository);
            }
            if (regexList != null) {
                for (String regex : regexList) {
                    uriBuilder.addParameter("regex", EncodingUtil.urlEncode((String)regex));
                }
            }
            return uriBuilder.build();
        }
        catch (URISyntaxException ex) {
            throw new SourceUnavailableException("Unable to construct proxy remote endpoint: " + ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<HttpPullRepositoryInfoXO> validateSuitableRemote(SourceConnection sourceConnection) {
        String url = String.valueOf(sourceConnection.getBaseUrl()) + "/service/rest/internal/replication/" + sourceConnection.getRepositoryName() + "/info";
        HttpGet request = new HttpGet(url);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (CloseableHttpClient client = this.createHttpClient(sourceConnection);){
                CloseableHttpResponse response = client.execute((HttpUriRequest)request);
                try {
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode == 200) {
                        Optional<HttpPullRepositoryInfoXO> optional = Optional.of((HttpPullRepositoryInfoXO)this.objectMapper.readValue(response.getEntity().getContent(), HttpPullRepositoryInfoXO.class));
                        return optional;
                    }
                }
                finally {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            this.log.warn("Unable to verify proxy remote endpoint: {}", (Object)e.getMessage());
            if (!this.log.isTraceEnabled()) return Optional.empty();
            this.log.trace("Stack trace:", (Throwable)e);
        }
        return Optional.empty();
    }

    @VisibleForTesting
    CloseableHttpClient createHttpClient(SourceConnection sourceConnection) {
        HttpClientConfiguration configuration = this.httpClientManager.newConfiguration();
        sourceConnection.getUsername().ifPresent(username -> {
            UsernameAuthenticationConfiguration authentication = new UsernameAuthenticationConfiguration();
            authentication.setUsername(username);
            authentication.setPassword(sourceConnection.getPassword().orElseThrow(() -> new RuntimeException("No password specified in source connection")));
            configuration.setAuthentication((AuthenticationConfiguration)authentication);
        });
        ConnectionConfiguration connection = new ConnectionConfiguration();
        if (sourceConnection.getTimeoutSeconds() != null) {
            connection.setTimeout(Time.seconds((long)sourceConnection.getTimeoutSeconds().intValue()));
        }
        connection.setUseTrustStore(Boolean.valueOf(sourceConnection.isUseTrustStore()));
        configuration.setConnection(connection);
        return this.httpClientManager.create((HttpClientPlan.Customizer)new ConfigurationCustomizer(configuration){

            public void customize(HttpClientPlan plan) {
                super.customize(plan);
                plan.getClient().useSystemProperties();
                plan.getClient().addInterceptorFirst((HttpRequestInterceptor)new PreemptiveAuthHttpRequestInterceptor());
            }
        });
    }
}

