/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal.pull;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.Configuration;

public class SourceConnection {
    private static final Logger log = LoggerFactory.getLogger(SourceConnection.class);
    private static final Pattern NEXUS_REPOSITORY_PATTERN = Pattern.compile("^(.+)/repository/(.+?)(/.*)?$");
    private final String repositoryName;
    private final String baseUrl;
    @Nullable
    private final String username;
    @Nullable
    private final String password;
    private final boolean useTrustStore;
    private final Integer timeoutSeconds;

    public SourceConnection(String repositoryName, String baseUrl, @Nullable String username, @Nullable String password, boolean useTrustStore, @Nullable Integer timeoutSeconds) {
        this.repositoryName = repositoryName;
        this.baseUrl = baseUrl;
        this.username = username;
        this.password = password;
        this.useTrustStore = useTrustStore;
        this.timeoutSeconds = timeoutSeconds;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public Optional<String> getUsername() {
        return Optional.ofNullable(this.username);
    }

    public Optional<String> getPassword() {
        return Optional.ofNullable(this.password);
    }

    public boolean isUseTrustStore() {
        return this.useTrustStore;
    }

    public Integer getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public static Optional<SourceConnection> from(Repository repository) {
        return SourceConnection.from(repository.getConfiguration());
    }

    public static Optional<SourceConnection> from(Configuration originalConfig) {
        Configuration config = originalConfig.copy();
        NestedAttributesMap proxyAttributes = config.attributes("proxy");
        if (proxyAttributes == null) {
            return Optional.empty();
        }
        String remoteUrl = (String)proxyAttributes.get("remoteUrl", String.class);
        if (remoteUrl == null || remoteUrl.isEmpty()) {
            return Optional.empty();
        }
        Matcher matcher = NEXUS_REPOSITORY_PATTERN.matcher(remoteUrl);
        if (!matcher.matches()) {
            log.error("Remote url of repository {} is not a Nexus Repository - {}", (Object)config.getRepositoryName(), (Object)remoteUrl);
            return Optional.empty();
        }
        String baseUrl = matcher.group(1);
        String repositoryName = matcher.group(2);
        NestedAttributesMap httpclient = config.attributes("httpclient");
        NestedAttributesMap authentication = httpclient.child("authentication");
        String username = (String)authentication.get("username", String.class);
        String password = (String)authentication.get("password", String.class);
        boolean useTrustStore = (Boolean)httpclient.child("connection").get("useTrustStore", (Object)false);
        Integer timeoutSeconds = SourceConnection.toInt((Number)httpclient.child("connection").get("timeout", Number.class));
        return Optional.of(new SourceConnection(repositoryName, baseUrl, username, password, useTrustStore, timeoutSeconds));
    }

    protected static Integer toInt(Number num) {
        return num == null ? null : Integer.valueOf(num.intValue());
    }
}

