/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal.pull;

import com.sonatype.analytics.proxy.PullReplicationAnalytics;
import com.sonatype.nexus.replication.internal.pull.PullReplicationService;
import com.sonatype.nexus.replication.internal.pull.PullResponse;
import com.sonatype.nexus.replication.internal.pull.SourceConnection;
import com.sonatype.nexus.replication.internal.pull.SourceInstanceConnector;
import com.sonatype.nexus.replication.internal.pull.SourceUnavailableException;
import com.sonatype.nexus.replication.rest.model.HttpPullResponseXO;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.http.client.HttpResponseException;
import org.apache.http.conn.HttpHostConnectException;
import org.sonatype.nexus.logging.task.TaskLogType;
import org.sonatype.nexus.logging.task.TaskLogging;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.RepositoryTaskSupport;
import org.sonatype.nexus.repository.httpclient.HttpClientFacet;
import org.sonatype.nexus.repository.httpclient.RemoteConnectionStatus;
import org.sonatype.nexus.repository.httpclient.RemoteConnectionStatusType;
import org.sonatype.nexus.repository.replication.PullReplicationSupport;
import org.sonatype.nexus.repository.routing.RoutingRuleHelper;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.CancelableHelper;
import org.sonatype.nexus.scheduling.TaskInterruptedException;

@Named
@TaskLogging(value=TaskLogType.REPLICATION_LOGGING)
public class PullReplicationTask
extends RepositoryTaskSupport
implements Cancelable {
    private final PullReplicationService pullReplicationService;
    private final SourceInstanceConnector sourceInstanceConnector;
    private final PullReplicationAnalytics pullReplicationAnalytics;
    private final RoutingRuleHelper routingRuleHelper;
    private final Map<String, PullReplicationSupport> pullReplicationSupportMap;

    @Inject
    public PullReplicationTask(PullReplicationService pullReplicationService, SourceInstanceConnector sourceInstanceConnector, PullReplicationAnalytics pullReplicationAnalytics, RoutingRuleHelper routingRuleHelper, Map<String, PullReplicationSupport> pullReplicationSupportMap) {
        this.pullReplicationService = Objects.requireNonNull(pullReplicationService);
        this.sourceInstanceConnector = Objects.requireNonNull(sourceInstanceConnector);
        this.pullReplicationAnalytics = Objects.requireNonNull(pullReplicationAnalytics);
        this.routingRuleHelper = Objects.requireNonNull(routingRuleHelper);
        this.pullReplicationSupportMap = pullReplicationSupportMap;
    }

    protected void execute(Repository repository) {
        String repoName = repository.getName();
        this.log.info("Start replicating on {}", (Object)repoName);
        SourceConnection.from(repository).ifPresent(sourceConnection -> {
            HttpPullResponseXO result;
            try {
                result = this.sourceInstanceConnector.fetchAssets((SourceConnection)sourceConnection, this.pullReplicationService.getContinuationToken(repository), this.pullReplicationService.getAssetPathRegex(repository));
                int originalCount = result.getAssetPaths().size();
                this.log.debug("Asset paths fetched for {} count={}", (Object)repoName, (Object)originalCount);
                this.filterByRoutingRule(repository, result);
            }
            catch (SourceUnavailableException e) {
                String errorMessage = "Pull replication task could not complete because there was an error communicating with the source";
                if (e.getCause() instanceof HttpResponseException) {
                    int statusCode = ((HttpResponseException)e.getCause()).getStatusCode();
                    this.log.debug(String.format("%s, statusCode %d", errorMessage, statusCode), (Throwable)(this.log.isErrorEnabled() ? e : null));
                    this.pullReplicationAnalytics.incrementErrorCount(statusCode);
                } else if (e.getCause() instanceof HttpHostConnectException) {
                    this.log.debug(String.format("%s, status %s", errorMessage, "Remote-Unavailable"), (Throwable)(this.log.isErrorEnabled() ? e : null));
                    this.pullReplicationAnalytics.incrementErrorCount("Remote-Unavailable");
                } else {
                    this.log.debug(String.format("%s, Unknown Error", errorMessage), (Throwable)(this.log.isErrorEnabled() ? e : null));
                    this.pullReplicationAnalytics.incrementErrorCount(e.getCause().getClass().getName());
                }
                throw new TaskInterruptedException("Error communicating with source for " + repoName, true);
            }
            if (result.getAddedToRepository() == null) {
                throw new RuntimeException("addedToRepository can not be null repo=" + repoName);
            }
            OffsetDateTime lastAddedToRepository = result.getAddedToRepository().toInstant().atOffset(ZoneOffset.UTC);
            this.pullAssets(repository, result, sourceConnection.getBaseUrl());
            this.pullReplicationService.setContinuationToken(repository, lastAddedToRepository);
        });
        this.log.info("Finished replicating on {}", (Object)repoName);
    }

    private void filterByRoutingRule(Repository repository, HttpPullResponseXO result) {
        if (this.routingRuleHelper.hasRoutingRule(repository)) {
            int originalCount = result.getAssetPaths().size();
            List<String> filteredAssetPaths = result.getAssetPaths().stream().filter(path -> {
                boolean isAllowed = this.routingRuleHelper.isAllowed(repository, path);
                if (!isAllowed) {
                    this.log.trace("Skipping asset path {} due to routing rule", path);
                }
                return isAllowed;
            }).collect(Collectors.toList());
            this.log.debug("Skipped {} assets due to routing rule", (Object)(originalCount - filteredAssetPaths.size()));
            result.setAssetPaths(filteredAssetPaths);
        }
    }

    private void pullAssets(Repository repository, HttpPullResponseXO result, String baseUrl) {
        String repoName = repository.getName();
        this.log.info("Starting to pull assets on {}", (Object)repoName);
        int successCount = 0;
        for (String path : result.getAssetPaths()) {
            CancelableHelper.checkCancellation();
            try {
                RemoteConnectionStatus remoteConnectionStatus;
                PullResponse pullResponse;
                PullReplicationSupport formatSupport = this.pullReplicationSupportMap.get(repository.getFormat().getValue());
                if (formatSupport != null) {
                    path = formatSupport.translatePath(repository, path);
                }
                if ((pullResponse = this.pullReplicationService.pullAsset(repository, path, baseUrl)).getResponse().isPresent() && pullResponse.getResponse().get().getStatus().isSuccessful()) {
                    ++successCount;
                }
                if ((remoteConnectionStatus = ((HttpClientFacet)repository.facet(HttpClientFacet.class)).getStatus()).getType() == RemoteConnectionStatusType.AUTO_BLOCKED_UNAVAILABLE) {
                    this.pullReplicationAnalytics.incrementErrorCount(remoteConnectionStatus.getStatusCode().orElse(0).intValue());
                    throw new TaskInterruptedException("Pre-emptive pull failed for " + repoName + " path=" + pullResponse.getPath(), true);
                }
                if (!pullResponse.getException().isPresent()) continue;
                String message = String.format("Error pulling asset for %s but remote was not blocked, continuing to pre-emptively pull assets path=%s", repoName, path);
                this.log.warn(message, this.log.isDebugEnabled() ? (Throwable)pullResponse.getException().orElse(null) : null);
                int statusCode = pullResponse.getResponse().map(response -> response.getStatus().getCode()).orElse(0);
                this.pullReplicationAnalytics.incrementErrorCount(statusCode);
            }
            catch (TaskInterruptedException tie) {
                throw tie;
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected error pulling asset for " + repoName + " path=" + path, e);
            }
        }
        this.log.info("Finished pulling assets for {} {}/{} successful", new Object[]{repoName, successCount, result.getAssetPaths().size()});
    }

    protected boolean appliesTo(Repository repository) {
        return true;
    }

    public String getMessage() {
        return "Pull Replication";
    }
}

