/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal.pull;

import com.sonatype.nexus.replication.internal.pull.PullResponse;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.BaseUrlHolder;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.AttributeOperation;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.ViewFacet;

@Named
public class PullReplicationService
extends ComponentSupport {
    public static final String REPLICATION_KEY = "replication";
    public static final String ENABLED_KEY = "enabled";

    public PullResponse pullAsset(Repository repository, String path, String baseUrl) {
        BaseUrlHolder.set((String)baseUrl, (String)path);
        Request request = new Request.Builder().action("GET").path(path).build();
        try {
            Context context = new Context(repository, request);
            context.getAttributes().set("IS_REPLICATION_REQUEST", (Object)true);
            Response response = ((ViewFacet)repository.facet(ViewFacet.class)).dispatch(request, context);
            String status = String.valueOf(response.getStatus().getCode());
            this.log.debug("Pulled asset via replication for repo {} path={} status={}", new Object[]{repository.getName(), path, status});
            return new PullResponse(response, repository, path);
        }
        catch (Exception e) {
            return new PullResponse(e, repository, path);
        }
    }

    @Nullable
    public List<String> getAssetPathRegex(Repository repository) {
        String assetPathRegexValue = (String)repository.getConfiguration().copy().attributes(REPLICATION_KEY).get("assetPathRegex", String.class);
        if (assetPathRegexValue != null) {
            return Arrays.asList(assetPathRegexValue.split(","));
        }
        return null;
    }

    @Nullable
    public OffsetDateTime getContinuationToken(Repository repository) {
        ContentFacet contentFacet = (ContentFacet)repository.facet(ContentFacet.class);
        String continuationTokenValue = (String)contentFacet.attributes(REPLICATION_KEY).get("continuationToken", String.class);
        return Optional.ofNullable(continuationTokenValue).map(OffsetDateTime::parse).orElse(null);
    }

    public void setContinuationToken(Repository repository, OffsetDateTime continuationToken) {
        ContentFacet contentFacet = (ContentFacet)repository.facet(ContentFacet.class);
        OffsetDateTime utcContinuationToken = continuationToken.withOffsetSameInstant(ZoneOffset.UTC);
        try {
            NestedAttributesMap currentContent = contentFacet.attributes(REPLICATION_KEY);
            currentContent.set("continuationToken", (Object)utcContinuationToken.toString());
            contentFacet.attributes(AttributeOperation.SET, REPLICATION_KEY, (Object)currentContent.backing());
        }
        catch (Exception e) {
            this.log.warn("Unable to update addedToRepository attribute in repository attributes", (Throwable)e);
        }
    }

    public void setContinuationTokenIfAbsent(Repository repository) {
        if (this.getContinuationToken(repository) == null) {
            this.setContinuationToken(repository, OffsetDateTime.now());
        }
    }

    public boolean isReplicationEnabled(Repository targetRepository) {
        return Boolean.TRUE.equals(targetRepository.getConfiguration().attributes(REPLICATION_KEY).get(ENABLED_KEY, Boolean.class, (Object)false));
    }
}

