/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal.db.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import com.sonatype.nexus.replication.ReplicationConnectionStore;
import com.sonatype.nexus.replication.ReplicationDuplicateException;
import com.sonatype.nexus.replication.db.model.ReplicationConnection;
import com.sonatype.nexus.replication.internal.audit.ReplicationConfigurationCreatedEvent;
import com.sonatype.nexus.replication.internal.audit.ReplicationConfigurationDeletedEvent;
import com.sonatype.nexus.replication.internal.audit.ReplicationConfigurationUpdatedEvent;
import com.sonatype.nexus.replication.internal.db.orient.OrientReplicationConnectionEntityAdapter;
import com.sonatype.nexus.replication.internal.db.orient.ReplicationConnectionEntity;
import com.sonatype.nexus.replication.internal.tasks.ReplicationBackfillQueueTaskManager;
import java.util.List;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;

@Named(value="orientReplicationConnectionStore")
@Priority(value=0x7FFFFFFF)
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
public class OrientReplicationConnectionStore
extends StateGuardLifecycleSupport
implements ReplicationConnectionStore {
    public static final String NAME = "orientReplicationConnectionStore";
    private final OrientReplicationConnectionEntityAdapter adapter;
    private final Provider<DatabaseInstance> database;
    private final ReplicationBackfillQueueTaskManager replicationBackfillQueueTaskManager;
    private final EventManager eventManager;

    @Inject
    public OrientReplicationConnectionStore(OrientReplicationConnectionEntityAdapter adapter, @Named(value="config") @Named(value="config") Provider<DatabaseInstance> database, ReplicationBackfillQueueTaskManager replicationBackfillQueueTaskManager, EventManager eventManager) {
        this.adapter = (OrientReplicationConnectionEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)adapter)));
        this.database = (Provider)Preconditions.checkNotNull(database);
        this.replicationBackfillQueueTaskManager = (ReplicationBackfillQueueTaskManager)Preconditions.checkNotNull((Object)replicationBackfillQueueTaskManager);
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
    }

    protected void doStart() throws Exception {
        super.doStart();
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.database.get()).connect();){
            this.adapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public ReplicationConnection newReplicationConnection() {
        return new ReplicationConnectionEntity();
    }

    @Override
    @Guarded(by={"STARTED"})
    public List<ReplicationConnection> list() {
        return (List)OrientTransactional.inTx(this.database).call(db -> ImmutableList.copyOf((Iterable)this.adapter.browse(db)));
    }

    @Override
    @Guarded(by={"STARTED"})
    public void create(ReplicationConnection replicationConnection) throws ReplicationDuplicateException {
        Preconditions.checkNotNull((Object)replicationConnection);
        try {
            OrientTransactional.inTxRetry(this.database).run(db -> {
                ODocument oDocument = this.adapter.addEntity(db, (Entity)this.cast(replicationConnection));
            });
        }
        catch (ORecordDuplicatedException e) {
            throw new ReplicationDuplicateException((Exception)((Object)e));
        }
        if (replicationConnection.isIncludeExistingContent()) {
            this.replicationBackfillQueueTaskManager.backfillRepository(replicationConnection.getSourceRepositoryName());
        }
        this.eventManager.post((Object)new ReplicationConfigurationCreatedEvent(replicationConnection));
    }

    @Override
    @Guarded(by={"STARTED"})
    public void update(ReplicationConnection configuration) {
        Preconditions.checkNotNull((Object)configuration);
        OrientTransactional.inTxRetry(this.database).run(db -> {
            boolean bl = this.adapter.update(db, this.cast(configuration));
        });
        this.eventManager.post((Object)new ReplicationConfigurationUpdatedEvent(configuration));
    }

    @Override
    @Guarded(by={"STARTED"})
    public boolean delete(String id) {
        Preconditions.checkNotNull((Object)id);
        boolean deleteSuccessful = (Boolean)OrientTransactional.inTxRetry(this.database).call(db -> this.adapter.delete(db, id));
        if (deleteSuccessful) {
            this.eventManager.post((Object)new ReplicationConfigurationDeletedEvent(id));
        }
        return deleteSuccessful;
    }

    private ReplicationConnectionEntity cast(ReplicationConnection replicationConnection) {
        return (ReplicationConnectionEntity)replicationConnection;
    }

    @Override
    public void detach(ReplicationConnection con) {
        this.cast(con).setEntityMetadata(null);
    }
}

