/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal.db.orient;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.sonatype.nexus.replication.internal.db.orient.ReplicationConnectionEntity;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;
import org.sonatype.nexus.orient.entity.action.DeleteEntityByPropertyAction;
import org.sonatype.nexus.orient.entity.action.UpdateEntityByPropertyAction;
import org.sonatype.nexus.security.PasswordHelper;

@Named
@Singleton
public class OrientReplicationConnectionEntityAdapter
extends IterableEntityAdapter<ReplicationConnectionEntity> {
    public static final String DB_CLASS_TYPE = "replication_connection";
    private static final String DB_CLASS = new OClassNameBuilder().type("replication_connection").build();
    private static final String P_ID = "id";
    private static final String P_NAME = "name";
    private static final String P_SOURCE_REPOSITORY_NAME = "source_repository_name";
    private static final String P_DESTINATION_INSTANCE_URL = "destination_instance_url";
    private static final String P_DESTINATION_INSTANCE_USERNAME = "destination_instance_username";
    private static final String P_DESTINATION_INSTANCE_PASSWORD = "destination_instance_password";
    private static final String P_DESTINATION_REPOSITORY_NAME = "destination_repository_name";
    private static final String P_CONTENT_REGEXES = "content_regexes";
    private static final String P_INCLUDE_EXISTING_CONTENT = "include_existing_content";
    private static final String P_USE_TRUST_STORE = "use_trust_store";
    private final UpdateEntityByPropertyAction<ReplicationConnectionEntity> update = new UpdateEntityByPropertyAction((EntityAdapter)this, new String[]{"name"});
    public static final String I_NAME = new OIndexNameBuilder().type(DB_CLASS).property("name").build();
    private final DeleteEntityByPropertyAction delete = new DeleteEntityByPropertyAction((EntityAdapter)this, new String[]{"id"});
    private final PasswordHelper passwordHelper;

    @Inject
    public OrientReplicationConnectionEntityAdapter(PasswordHelper passwordHelper) {
        super(DB_CLASS);
        this.passwordHelper = (PasswordHelper)Preconditions.checkNotNull((Object)passwordHelper);
    }

    protected ReplicationConnectionEntity newEntity() {
        return new ReplicationConnectionEntity();
    }

    protected void readFields(ODocument document, ReplicationConnectionEntity entity) {
        entity.setId((String)document.field(P_ID, OType.STRING));
        entity.setName((String)document.field(P_NAME, OType.STRING));
        entity.setSourceRepositoryName((String)document.field(P_SOURCE_REPOSITORY_NAME, OType.STRING));
        entity.setDestinationInstanceUrl((String)document.field(P_DESTINATION_INSTANCE_URL, OType.STRING));
        entity.setDestinationInstanceUsername((String)document.field(P_DESTINATION_INSTANCE_USERNAME, OType.STRING));
        entity.setDestinationInstancePassword(this.passwordHelper.tryDecrypt((String)document.field(P_DESTINATION_INSTANCE_PASSWORD, OType.STRING)));
        entity.setDestinationRepositoryName((String)document.field(P_DESTINATION_REPOSITORY_NAME, OType.STRING));
        entity.setContentRegexes((List)document.field(P_CONTENT_REGEXES, OType.EMBEDDEDLIST));
        entity.setIncludeExistingContent((Boolean)document.field(P_INCLUDE_EXISTING_CONTENT, OType.BOOLEAN));
        entity.setUseTrustStore((Boolean)document.field(P_USE_TRUST_STORE, OType.BOOLEAN));
    }

    protected void writeFields(ODocument document, ReplicationConnectionEntity entity) {
        document.field(P_ID, (Object)entity.getId());
        document.field(P_NAME, (Object)entity.getName());
        document.field(P_SOURCE_REPOSITORY_NAME, (Object)entity.getSourceRepositoryName());
        document.field(P_DESTINATION_INSTANCE_URL, (Object)entity.getDestinationInstanceUrl());
        document.field(P_DESTINATION_INSTANCE_USERNAME, (Object)entity.getDestinationInstanceUsername());
        document.field(P_DESTINATION_INSTANCE_PASSWORD, (Object)this.passwordHelper.encrypt(entity.getDestinationInstancePassword()));
        document.field(P_DESTINATION_REPOSITORY_NAME, (Object)entity.getDestinationRepositoryName());
        document.field(P_CONTENT_REGEXES, entity.getContentRegexes());
        document.field(P_INCLUDE_EXISTING_CONTENT, (Object)entity.isIncludeExistingContent());
        document.field(P_USE_TRUST_STORE, (Object)entity.isUseTrustStore());
    }

    protected void defineType(OClass type) {
        type.createProperty(P_ID, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_NAME, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_SOURCE_REPOSITORY_NAME, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_DESTINATION_INSTANCE_URL, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_DESTINATION_INSTANCE_USERNAME, OType.STRING);
        type.createProperty(P_DESTINATION_INSTANCE_PASSWORD, OType.STRING);
        type.createProperty(P_DESTINATION_REPOSITORY_NAME, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_CONTENT_REGEXES, OType.EMBEDDEDLIST);
        type.createProperty(P_INCLUDE_EXISTING_CONTENT, OType.BOOLEAN);
        type.createProperty(P_USE_TRUST_STORE, OType.BOOLEAN).setDefaultValue("false");
        type.createIndex(I_NAME, OClass.INDEX_TYPE.UNIQUE, new String[]{P_NAME});
    }

    public boolean delete(ODatabaseDocumentTx db, String id) {
        return this.delete.execute(db, new Object[]{id});
    }

    public boolean update(ODatabaseDocumentTx db, ReplicationConnectionEntity entity) {
        return this.update.execute(db, (Entity)entity, new Object[]{entity.getName()});
    }
}

