/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal.db.datastore;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.replication.internal.BlobAttributeBackfillService;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.BlobAttributes;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.RepositoryContent;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.store.AssetStore;
import org.sonatype.nexus.repository.manager.RepositoryManager;

@Named
public class BlobAttributeBackfillServiceImpl
extends ComponentSupport
implements BlobAttributeBackfillService {
    private final RepositoryManager repositoryManager;
    private final NodeAccess nodeAccess;

    @Inject
    public BlobAttributeBackfillServiceImpl(RepositoryManager repositoryManager, NodeAccess nodeAccess) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
    }

    @Override
    public void backfillBlobAttributes(BlobStore blobStore, BlobId blobId, BlobAttributes blobAttributes) {
        this.log.trace("Backfilling attributes on blob {}", (Object)blobId);
        String repositoryName = this.getRepositoryName(blobAttributes);
        Repository repository = this.repositoryManager.get(repositoryName);
        if (repository != null) {
            ContentFacetSupport contentFacet = (ContentFacetSupport)repository.facet(ContentFacet.class);
            AssetStore assetStore = contentFacet.stores().assetStore;
            BlobRef blobRef = new BlobRef(this.nodeAccess.getId(), blobStore.getBlobStoreConfiguration().getName(), blobId.asUniqueString());
            assetStore.findByBlobRef(contentFacet.contentRepositoryId().intValue(), blobRef).ifPresent(asset -> this.updateMetadata(contentFacet, (Asset)asset, blobStore, blobRef.getBlobId()));
        } else {
            this.log.warn("repository {} referenced by blob {} does not exist.", (Object)repositoryName, (Object)blobId);
        }
    }

    private void updateMetadata(ContentFacetSupport contentFacet, Asset asset, BlobStore blobStore, BlobId blobId) {
        this.log.trace("Updating metadata from asset {}", (Object)asset);
        NestedAttributesMap componentAttributes = asset.component().map(RepositoryContent::attributes).orElse(null);
        contentFacet.blobMetadataStorage().attach(blobStore, blobId, componentAttributes, asset.attributes(), ((AssetBlob)asset.blob().get()).checksums());
    }
}

