/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal.db.datastore;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.replication.ReplicationConnectionManager;
import com.sonatype.nexus.replication.ReplicationQueueManager;
import com.sonatype.nexus.replication.internal.ReplicationUtil;
import com.sonatype.nexus.replication.internal.db.AssetEventListenerSupport;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.event.asset.AssetCreatedEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetDeletedEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetUpdatedEvent;
import org.sonatype.nexus.repository.replication.BlobEventType;

@Named
@Singleton
public class AssetEventListener
extends AssetEventListenerSupport
implements EventAware {
    @Inject
    public AssetEventListener(ReplicationQueueManager replicationQueueManager, ReplicationConnectionManager replicationConnectionManager, ReplicationUtil replicationUtil) {
        super(replicationConnectionManager, replicationQueueManager, replicationUtil);
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(AssetCreatedEvent event) {
        this.addToQueue(BlobEventType.ADDED, event.getRepository(), event.getAsset());
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(AssetUpdatedEvent event) {
        this.addToQueue(BlobEventType.UPDATED, event.getRepository(), event.getAsset());
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(AssetDeletedEvent event) {
        this.addToQueue(BlobEventType.DELETED, event.getRepository(), event.getAsset());
    }

    private void addToQueue(BlobEventType blobEventType, Optional<Repository> repository, @Nullable Asset asset) {
        if (!repository.isPresent()) {
            this.log.debug("Event contains null repository, not going to process for replication");
        } else if (this.validate(asset, repository.get().getName())) {
            if (!asset.blob().isPresent()) {
                this.log.debug("Asset contains null blobRef, not going to process for replication: {}", (Object)asset.path());
            } else {
                this.addToQueue(((AssetBlob)asset.blob().get()).blobRef().getBlobId().asUniqueString(), repository.get().getName(), blobEventType, asset.path());
            }
        }
    }
}

