/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal.db;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.replication.ReplicationConnectionManager;
import com.sonatype.nexus.replication.ReplicationQueueManager;
import com.sonatype.nexus.replication.db.model.ReplicationConnection;
import com.sonatype.nexus.replication.internal.ReplicationUtil;
import java.util.Collection;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.replication.BlobEvent;
import org.sonatype.nexus.repository.replication.BlobEventType;

public abstract class AssetEventListenerSupport
extends ComponentSupport {
    private final ReplicationConnectionManager replicationConnectionManager;
    protected final ReplicationQueueManager replicationQueueManager;
    private final ReplicationUtil replicationUtil;

    protected AssetEventListenerSupport(ReplicationConnectionManager replicationConnectionManager, ReplicationQueueManager replicationQueueManager, ReplicationUtil replicationUtil) {
        this.replicationConnectionManager = (ReplicationConnectionManager)Preconditions.checkNotNull((Object)replicationConnectionManager);
        this.replicationQueueManager = (ReplicationQueueManager)Preconditions.checkNotNull((Object)replicationQueueManager);
        this.replicationUtil = (ReplicationUtil)Preconditions.checkNotNull((Object)replicationUtil);
    }

    protected boolean validate(Object asset, String repositoryName) {
        if (!this.replicationUtil.isReplicationEnabled()) {
            this.log.debug("Ignoring event for asset, as replication is disabled");
        } else if (asset == null) {
            this.log.debug("Found null asset in event, not going to process for replication");
        } else if (repositoryName == null) {
            this.log.debug("Found null repository name in event, not going to process for replication");
        } else if (!this.isRepoEnabled(repositoryName)) {
            this.log.debug("Ignoring event for asset, as repository {} does not have replication enabled", (Object)repositoryName);
        } else {
            return true;
        }
        return false;
    }

    protected void addToQueue(String blobId, String repositoryName, BlobEventType blobEventType, String assetName) {
        Collection<ReplicationConnection> replicationConnections = this.replicationConnectionManager.listBySourceRepository(repositoryName);
        replicationConnections.forEach(replicationConnection -> {
            this.addToQueue(blobId, repositoryName, blobEventType, assetName, (ReplicationConnection)replicationConnection);
            this.log.debug("Added {} to replicationConnection {} queue with {} type event (queue size is {})", new Object[]{assetName, replicationConnection.getId(), blobEventType, this.replicationQueueManager.size(replicationConnection.getId())});
        });
    }

    protected void addToQueue(String blobId, String repositoryName, BlobEventType blobEventType, String assetName, ReplicationConnection replicationConnection) {
        this.replicationQueueManager.addToQueue(replicationConnection.getId(), new BlobEvent().withBlobEventType(blobEventType).withBlobId(blobId).withAssetPath(assetName).withRepositoryName(repositoryName).withReplicationConnectionId(replicationConnection.getId()));
    }

    protected boolean isRepoEnabled(String repository) {
        for (ReplicationConnection replicationConnection : this.replicationConnectionManager.list()) {
            if (!repository.equals(replicationConnection.getSourceRepositoryName())) continue;
            return true;
        }
        return false;
    }
}

