/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal.customizers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.sonatype.nexus.blobstore.api.RawObjectAccess;
import org.sonatype.nexus.supportzip.GeneratedContentSourceSupport;
import org.sonatype.nexus.supportzip.SupportBundle;

public class ReplicationLogsGenerator
extends GeneratedContentSourceSupport {
    private final RawObjectAccess raw;
    private final Path path;

    public ReplicationLogsGenerator(SupportBundle.ContentSource.Type type, String pathString, SupportBundle.ContentSource.Priority priority, RawObjectAccess raw, Path path) {
        super(type, pathString, priority);
        this.raw = raw;
        this.path = path;
    }

    protected void generate(File file) throws Exception {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream in = this.raw.getRawObject(this.path);){
                if (in != null) {
                    FileUtils.copyInputStreamToFile((InputStream)in, (File)file);
                } else {
                    this.log.warn("Not including missing replication log file");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.log.warn("Unable to include replication log file", (Throwable)e);
        }
    }
}

