/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal.audit;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.replication.db.model.ReplicationConnection;
import com.sonatype.nexus.replication.internal.audit.ReplicationConfigurationCreatedEvent;
import com.sonatype.nexus.replication.internal.audit.ReplicationConfigurationDeletedEvent;
import com.sonatype.nexus.replication.internal.audit.ReplicationConfigurationEvent;
import com.sonatype.nexus.replication.internal.audit.ReplicationConfigurationUpdatedEvent;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.audit.AuditData;
import org.sonatype.nexus.audit.AuditorSupport;
import org.sonatype.nexus.common.event.EventAware;

@Named
@Singleton
public class ReplicationConfigurationAuditor
extends AuditorSupport
implements EventAware {
    public static final String DOMAIN = "replication";

    public ReplicationConfigurationAuditor() {
        this.registerType(ReplicationConfigurationCreatedEvent.class, "created");
        this.registerType(ReplicationConfigurationDeletedEvent.class, "deleted");
        this.registerType(ReplicationConfigurationUpdatedEvent.class, "updated");
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(ReplicationConfigurationEvent event) {
        if (this.isRecording()) {
            AuditData data = new AuditData();
            data.setDomain(DOMAIN);
            data.setType(this.type(event.getClass()));
            data.setContext(event.getReplicationId());
            if (!(event instanceof ReplicationConfigurationDeletedEvent)) {
                ReplicationConnection configuration = event.getConfiguration();
                Map attributes = data.getAttributes();
                attributes.put("id", configuration.getId());
                attributes.put("name", configuration.getName());
                attributes.put("includeExistingContent", configuration.isIncludeExistingContent());
                attributes.put("contentRegexes", configuration.getContentRegexes());
                attributes.put("sourceRepositoryName", configuration.getSourceRepositoryName());
                attributes.put("destinationRepositoryName", configuration.getDestinationRepositoryName());
                attributes.put("destinationInstanceUrl", configuration.getDestinationInstanceUrl());
            }
            this.record(data);
        }
    }
}

