/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.blobstore.group.tasks.BlobStoreGroupMemberRemovalTaskConfiguration;
import com.sonatype.nexus.blobstore.group.tasks.BlobStoreGroupMemberRemovalTaskValidator;
import com.sonatype.nexus.replication.ReplicationConnectionManager;
import com.sonatype.nexus.replication.ReplicationEnableException;
import com.sonatype.nexus.replication.ReplicationTargetService;
import com.sonatype.nexus.replication.db.model.ReplicationConnection;
import com.sonatype.nexus.replication.internal.TaskValidationUtil;
import com.sonatype.nexus.replication.internal.TaskValidator;
import com.sonatype.nexus.repository.move.tasks.RepositoryMoveTaskConfiguration;
import com.sonatype.nexus.repository.move.tasks.RepositoryMoveTaskValidator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.rest.ValidationErrorsException;

@Named
@Singleton
@FeatureFlag(name="nexus.replication.v1.enabled")
public class TaskValidatorImpl
extends ComponentSupport
implements TaskValidator,
RepositoryMoveTaskValidator,
BlobStoreGroupMemberRemovalTaskValidator {
    private final ReplicationTargetService replicationTargetService;
    private final RepositoryManager repositoryManager;
    private final ReplicationConnectionManager replicationConnectionManager;
    private final TaskValidationUtil taskValidationUtil;

    @Inject
    public TaskValidatorImpl(ReplicationTargetService replicationTargetService, RepositoryManager repositoryManager, ReplicationConnectionManager replicationConnectionManager, TaskValidationUtil taskValidationUtil) {
        this.replicationTargetService = (ReplicationTargetService)Preconditions.checkNotNull((Object)replicationTargetService);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.replicationConnectionManager = (ReplicationConnectionManager)Preconditions.checkNotNull((Object)replicationConnectionManager);
        this.taskValidationUtil = (TaskValidationUtil)((Object)Preconditions.checkNotNull((Object)((Object)taskValidationUtil)));
    }

    @Override
    public void validate(ReplicationConnection replicationConnection) throws ReplicationEnableException {
        this.taskValidationUtil.ensureNoConflictingTasks(replicationConnection.getSourceRepositoryName());
    }

    public void validate(RepositoryMoveTaskConfiguration repositoryMoveTaskConfiguration) {
        String repositoryName = repositoryMoveTaskConfiguration.getString("moveRepositoryName");
        this.log.debug("validating {} is not a replication target", (Object)repositoryName);
        if (this.replicationTargetService.getEnabledTargetRepositories().stream().anyMatch(repo -> repo.getName().equals(repositoryName))) {
            throw new ValidationErrorsException("moveRepositoryName", "Repository " + repositoryName + " cannot be moved because " + "it is configured as a target of replication. Please review the help documentation to resolve this condition.");
        }
    }

    public void validate(BlobStoreGroupMemberRemovalTaskConfiguration blobStoreGroupMemberRemovalTaskConfiguration) {
        String blobstoreGroupName = blobStoreGroupMemberRemovalTaskConfiguration.getFromGroup();
        String blobstoreMember = blobStoreGroupMemberRemovalTaskConfiguration.getMemberToRemove();
        List reposToGroup = StreamSupport.stream(this.repositoryManager.browseForBlobStore(blobstoreGroupName).spliterator(), false).map(Repository::getName).collect(Collectors.toList());
        List reposToMember = StreamSupport.stream(this.repositoryManager.browseForBlobStore(blobstoreMember).spliterator(), false).map(Repository::getName).collect(Collectors.toList());
        this.log.debug("validating {} and {} are not replication sources or targets", (Object)blobstoreGroupName, (Object)blobstoreMember);
        if (this.replicationTargetService.getEnabledTargetRepositories().stream().map(Repository::getName).anyMatch(repo -> reposToGroup.contains(repo) || reposToMember.contains(repo))) {
            throw new ValidationErrorsException("fromGroup", "Blobstore " + blobstoreMember + " cannot be removed from " + blobstoreGroupName + " because it is configured as a target of replication. " + "Please review the help documentation to resolve this condition.");
        }
        if (this.replicationConnectionManager.getSourceRepositories().stream().anyMatch(repo -> reposToGroup.contains(repo) || reposToMember.contains(repo))) {
            throw new ValidationErrorsException("fromGroup", "Blobstore " + blobstoreMember + " cannot be removed from " + blobstoreGroupName + " because it is configured as a source of replication. " + "Please review the help documentation to resolve this condition.");
        }
    }
}

