/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.replication.ReplicationEnableException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskScheduler;

@Named
@Singleton
@FeatureFlag(name="nexus.replication.v1.enabled")
public class TaskValidationUtil
extends ComponentSupport {
    private final TaskScheduler taskScheduler;
    private final RepositoryManager repositoryManager;

    @Inject
    public TaskValidationUtil(TaskScheduler taskScheduler, RepositoryManager repositoryManager) {
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
    }

    public void ensureNoConflictingTasks(String repositoryName) throws ReplicationEnableException {
        List tasks = this.taskScheduler.listsTasks().stream().filter(taskInfo -> this.isMoveTaskForRepo((TaskInfo)taskInfo, repositoryName) || this.isGroupMemberRemoveTaskForRepo((TaskInfo)taskInfo, repositoryName)).collect(Collectors.toList());
        for (TaskInfo taskInfo2 : tasks) {
            if (taskInfo2.getCurrentState().getState().isRunning()) {
                throw new ReplicationEnableException("Replication cannot be enabled because task " + taskInfo2.getName() + " is currently using repository " + repositoryName);
            }
            this.log.warn("Task {} is configured for repository {} when attempting to enable replication; this task should not be used with replication target repositories", (Object)taskInfo2.getName(), (Object)repositoryName);
        }
    }

    private boolean isMoveTaskForRepo(TaskInfo taskInfo, String repositoryName) {
        return taskInfo.getTypeId().equals("repository.move") && repositoryName.equals(taskInfo.getConfiguration().getString("moveRepositoryName"));
    }

    private boolean isGroupMemberRemoveTaskForRepo(TaskInfo taskInfo, String repositoryName) {
        return taskInfo.getTypeId().equals("blobstore.group.memberRemoval") && (this.blobstoreContainsRepo(taskInfo.getConfiguration().getString("fromGroup"), repositoryName) || this.blobstoreContainsRepo(taskInfo.getConfiguration().getString("memberToRemove"), repositoryName));
    }

    private boolean blobstoreContainsRepo(String blobstore, String repository) {
        return StreamSupport.stream(this.repositoryManager.browseForBlobStore(blobstore).spliterator(), false).map(Repository::getName).anyMatch(repoName -> repoName.equals(repository));
    }
}

